% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{cds_list_jobs}
\alias{cds_list_jobs}
\title{List jobs submitted to the Climate Data Service}
\usage{
cds_list_jobs(
  job_id = NULL,
  status = NULL,
  limit = 50,
  ...,
  token = cds_get_token()
)
}
\arguments{
\item{job_id}{The id of a specific job, if you want the results for that job. If \code{NULL}
(default) it is ignored.}

\item{status}{Only return jobs with the status stated by this argument. Default is \code{NULL}
meaning that jobs with any status are returned. Should be any of \code{"accepted"}, \code{"running"},
\code{"successful"}, \code{"failed"}, or \code{"rejected"}.}

\item{limit}{Use to limit the number of listed results. Defaults to \code{50}.}

\item{...}{Ignored}

\item{token}{An API key to be used for authentication. Will use
\code{cds_get_token()} by default.}
}
\value{
Returns a \code{data.frame} of submitted jobs.
}
\description{
Once submitted with \code{cds_submit_job()} you can check the status of the job with
this function. You can list all available jobs, or specific jobs.
}
\examples{
if (interactive() && cds_token_works()) {
  cds_list_jobs()
}
}
