% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_risk.R
\name{tabulate_risk}
\alias{tabulate_risk}
\title{Output risk measures to table}
\usage{
tabulate_risk(exp_risk_list, n_s)
}
\arguments{
\item{exp_risk_list}{A list of expected risk values
where the first element corresponds to the baseline policy.
This list can be generated using the \code{\link[=calculate_risk]{calculate_risk()}} function.}

\item{n_s}{A numeric value of the number of policy alternatives (including
the baseline policy) to include in the table.}
}
\value{
A character matrix of risk values and policy risk impact (\%)
for each policy alternative.
}
\description{
This function tabulates the expected risk values for each
policy alternative and the percent change in risk relative to the baseline scenario.
}
\examples{
tmin <- "2021-01-01"
tmax <- "2021-04-10"
Dt <- rep(750, nrow(psa_data$Baseline))

risk_measures <- calculate_risk(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt = Dt,
  Dt_max = TRUE
)

tabulate_risk(
  risk_measures,
  n_s = length(psa_data)
)
}
