% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.RRglm}
\alias{residuals.RRglm}
\title{Accessing GLMMRR Fits for fixed-effect models}
\usage{
\method{residuals}{RRglm}(
  object,
  type = c("deviance", "pearson", "working", "response", "partial", "deviance.grouped",
    "pearson.grouped", "hosmer-lemeshow"),
  ngroups = 10,
  ...
)
}
\arguments{
\item{object}{an object of class RRglm.}

\item{type}{the type of residuals which should be returned. The alternatives are: "deviance" (default), "pearson", "working", "response", "partial",
"deviance.grouped", "pearson.grouped" and "hosmer-lemeshow".}

\item{ngroups}{the number of groups if Hosmer-Lemeshow residuals are computed (default: 10).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector of residuals.
}
\description{
Compute residuals for RRglm objects. Extends \code{\link[stats:residuals.glm]{residuals.glm}} with residuals for grouped binary Randomized Response data.
}
\seealso{
\code{\link[stats:residuals.glm]{residuals.glm}}
}
