% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_manipulation_export.R
\name{rename_dims}
\alias{rename_dims}
\title{Rename Dimensions in SL4 or HAR Objects}
\usage{
rename_dims(data_obj, mapping_df, rename_list_names = FALSE)
}
\arguments{
\item{data_obj}{A structured SL4 or HAR object.}

\item{mapping_df}{A two-column data frame where the first column (\code{old}) contains the current names,
and the second column (\code{new}) contains the new names.}

\item{rename_list_names}{Logical. If \code{TRUE}, renames list element names. Default is \code{FALSE}.}
}
\value{
The modified SL4 or HAR object with updated dimension names and, optionally, updated list names.
}
\description{
Renames dimension and list names in structured SL4 or HAR objects.
}
\details{
\itemize{
\item Replaces old dimension names with new ones as specified in \code{mapping_df}.
\item If \code{rename_list_names = TRUE}, renames list element names as well.
\item Ensures consistency across SL4 and HAR datasets.
}
}
\examples{
# Import sample data:
sl4_data <- load_sl4x(system.file("extdata", "TAR10.sl4", package = "HARplus"))

# Define a renaming map
mapping_df <- data.frame(
  old = c("REG", "COMM"),
  new = c("Region", "Commodity")
)

# Rename columns in the dataset
rename_dims(sl4_data, mapping_df)

# Rename both columns and list names
rename_dims(sl4_data, mapping_df, rename_list_names = TRUE)

}
\seealso{
\code{\link{get_data_by_var}}, \code{\link{get_data_by_dims}}
}
\author{
Pattawee Puangchit
}
