% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_tv_plm.R, R/s3_methods_grouped_tv_plm.R
\name{grouped_tv_plm}
\alias{grouped_tv_plm}
\alias{summary.tv_gplm}
\alias{formula.tv_gplm}
\alias{df.residual.tv_gplm}
\alias{print.tv_gplm}
\alias{coef.tv_gplm}
\alias{residuals.tv_gplm}
\alias{fitted.tv_gplm}
\title{Grouped Time-varying Panel Data Model}
\usage{
grouped_tv_plm(
  formula,
  data,
  groups,
  index = NULL,
  n_periods = NULL,
  d = 3,
  M = floor(length(y)^(1/7) - log(p)),
  const_coef = NULL,
  rho = 0.04 * log(N * n_periods)/sqrt(N * n_periods),
  verbose = TRUE,
  parallel = TRUE,
  ...
)

\method{summary}{tv_gplm}(object, ...)

\method{formula}{tv_gplm}(x, ...)

\method{df.residual}{tv_gplm}(object, ...)

\method{print}{tv_gplm}(x, ...)

\method{coef}{tv_gplm}(object, ...)

\method{residuals}{tv_gplm}(object, ...)

\method{fitted}{tv_gplm}(object, ...)
}
\arguments{
\item{formula}{a formula object describing the model to be estimated.}

\item{data}{a \code{data.frame} or \code{matrix} holding a panel data set. If no \code{index} variables are provided, the panel must be balanced and ordered in the long format \eqn{\bold{Y}=(Y_1^\prime, \dots, Y_N^\prime)^\prime}, \eqn{Y_i = (Y_{i1}, \dots, Y_{iT})^\prime} with \eqn{Y_{it} = (y_{it}, \bold{x}_{it}^\prime)^\prime}. Conversely, if \code{data} is not ordered or not balanced, \code{data} must include two index variables that declare the cross-sectional unit \eqn{i} and the time period \eqn{t} of each observation.}

\item{groups}{a numerical or character vector of length \eqn{N} that indicates the group membership of each cross-sectional unit \eqn{i}.}

\item{index}{a character vector holding two strings. The first string denotes the name of the index variable identifying the cross-sectional unit \eqn{i}, and the second string represents the name of the variable declaring the time period \eqn{t}. The data is automatically sorted according to the variables in \code{index}, which may produce errors when the time index is a character variable. In case of a balanced panel data set that is ordered in the long format, \code{index} can be left empty if the number of time periods \code{n_periods} is supplied.}

\item{n_periods}{the number of observed time periods \eqn{T}. If an \code{index} character vector is passed, this argument can be left empty. Default is \code{NULL}.}

\item{d}{the polynomial degree of the B-splines. Default is 3.}

\item{M}{the number of interior knots of the B-splines. If left unspecified, the default heuristic \eqn{M = \text{floor}((NT)^{\frac{1}{7}} - \log(p))} is used, following Haimerl et al. (2025). Note that \eqn{M} does not include the boundary knots and the entire sequence of knots is of length \eqn{M + d + 1}.}

\item{const_coef}{a character vector containing the variable names of explanatory variables that enter with time-constant coefficients.}

\item{rho}{the tuning parameter balancing the fitness and penalty terms in the IC. If left unspecified, the heuristic \eqn{\rho = 0.07 \frac{\log(NT)}{\sqrt{NT}}} of Haimerl et al. (2025) is used. We recommend the default.}

\item{verbose}{logical. If \code{TRUE}, helpful warning messages are shown. Default is \code{TRUE}.}

\item{parallel}{logical. If \code{TRUE}, certain operations are parallelized across multiple cores. Default is \code{TRUE}.}

\item{...}{ellipsis}

\item{object}{of class \code{tv_gplm}.}

\item{x}{of class \code{tv_gplm}.}
}
\value{
An object of class \code{tv_gplm} holding
\item{\code{model}}{a \code{data.frame} containing the dependent and explanatory variables as well as cross-sectional and time indices,}
\item{\code{coefficients}}{let \eqn{p^{(1)}} denote the number of time-varying and \eqn{p^{(2)}} the number of time constant coefficients. A \code{list} holding (i) a \eqn{T \times p^{(1)} \times K} array of the group-specific functional coefficients and (ii) a \eqn{K \times p^{(2)}} matrix of time-constant estimates.}
\item{\code{groups}}{a \code{list} containing (i) the total number of groups \eqn{K} and (ii) a vector of group memberships \eqn{G = (g_1, \dots, g_N)}, where \eqn{g_i = k} if \eqn{i} is part of group \eqn{k},}
\item{\code{residuals}}{a vector of residuals of the demeaned model,}
\item{\code{fitted}}{a vector of fitted values of the demeaned model,}
\item{\code{args}}{a \code{list} of additional arguments,}
\item{\code{IC}}{a \code{list} containing (i) the value of the IC and (ii) the \emph{MSE},}
\item{\code{call}}{the function call.}

An object of class \code{tv_gplm} has \code{print}, \code{summary}, \code{fitted}, \code{residuals}, \code{formula}, \code{df.residual}, and \code{coef} S3 methods.
}
\description{
Estimate a time-varying panel data model subject to an observed group structure. Coefficient functions are homogeneous within groups but heterogeneous across groups.
Time-varying coefficient functions are approximated as polynomial B-splines. The function supports both static and dynamic panel data models.
}
\details{
Consider the time-varying panel data model
\deqn{y_{it} = \gamma_i^0 + \bold{\beta}^{0\prime}_{i} (t/T) \bold{x}_{it} + \epsilon_{it}, \quad i = 1, \dots, N, \; t = 1, \dots, T,}
where \eqn{y_{it}} is the scalar dependent variable, \eqn{\gamma_i^0} is an individual fixed effect, \eqn{\bold{x}_{it}} is a \eqn{p \times 1} vector of explanatory variables, and \eqn{\epsilon_{it}} is a zero mean error.
The \eqn{p}-dimensional coefficient vector \eqn{\bold{\beta}_{i}^0 (t/T)} contains smooth functions of time and follows the observed group pattern
\deqn{\bold{\beta}_i^0 \left(\frac{t}{T} \right) = \sum_{k = 1}^K \bold{\alpha}_k^0 \left( \frac{t}{T} \right) \bold{1} \{i \in G_k \},}
with \eqn{\cup_{k = 1}^K G_k = \{1, \dots, N\}}, \eqn{G_k \cap G_j = \emptyset} for any \eqn{k \neq j},  \eqn{k,j = 1, \dots, K}. The group structure \eqn{G_1, \dots, G_K} is determined by the argument \code{groups}.

The time-varying coefficient functions in \eqn{\bold{\alpha}_k (t/T)} and, in turn, \eqn{\bold{\beta}_i (t/T)} are estimated as polynomial B-splines. To this end, let \eqn{\bold{b}(v)} denote a \eqn{M + d +1} vector of polynomial basis functions with the polynomial degree \eqn{d} and \eqn{M} interior knots.
\eqn{\bold{\alpha}_k^0 (t/T)} is approximated by forming linear combinations of the basis functions \eqn{\bold{\alpha}_k^0 (t/T) \approx \bold{\Xi}_k^{0 \prime} \bold{b} (t/T)}, where \eqn{\bold{\Xi}_i^{0}} is a group-specific \eqn{(M + d + 1) \times p} matrix of spline control points.

To estimate \eqn{\bold{\Xi}_k^{0}}, we project the explanatory variables onto the spline basis system, resulting in the \eqn{(M + d + 1)p \times 1} regressor vector \eqn{\bold{z}_{it} = \bold{x}_{it} \otimes \bold{b}(v)}. Subsequently, the DGP can be reformulated as
\deqn{y_{it} = \gamma_i^0 + \bold{\pi}_{i}^{0 \prime} \bold{z}_{it} + u_{it},}
where \eqn{\bold{\pi}_i^0 = \text{vec}(\bold{\Pi}_i^0)} and \eqn{\bold{\Xi}_k^0 = \bold{\Pi}_i^0} if \eqn{i \in G_k}. \eqn{u_{it} = \epsilon_{it} + \eta_{it}} collects the idiosyncratic \eqn{\epsilon_{it}} and the sieve approximation error \eqn{\eta_{it}}. Then, we obtain \eqn{\hat{\bold{\xi}}_k = \text{vec}( \hat{\bold{\Xi}}_k)} by
\deqn{\hat{\xi}_k = \left( \sum_{i \in G_k} \sum_{t = 1}^T \tilde{\bold{z}}_{it} \tilde{\bold{z}}_{it}^\prime \right)^{-1} \sum_{i \in G_k} \sum_{t = 1}^T \tilde{\bold{z}}_{it} \tilde{y}_{it},}
with \eqn{\tilde{a}_{it} = a_{it} - T^{-1} \sum_{t = 1}^T a_{it}}, \eqn{a = \{y, \bold{z}\}} to concentrate out the fixed effect \eqn{\gamma_i^0} (within-transformation). Lastly, \eqn{\hat{\bold{\alpha}}_k (t/T) = \hat{\bold{\Xi}}_k^{\prime} \bold{b} (t/T)}. We refer to Haimerl et al. (2025, sec. 2) for more details.

In case of an unbalanced panel data set, the earliest and latest available observations per group define the start and end-points of the interval on which the group-specific time-varying coefficients are defined.
}
\examples{
# Simulate a time-varying panel with a trend and a group pattern
set.seed(1)
sim <- sim_tv_DGP(N = 10, n_periods = 50, intercept = TRUE, p = 2)
df <- data.frame(y = c(sim$y), X = sim$X)
groups <- sim$groups

# Estimate the time-varying grouped panel data model
estim <- grouped_tv_plm(y ~ ., data = df, n_periods = 50, groups = groups)
summary(estim)

}
\references{
Haimerl, P., Smeekes, S., & Wilms, I. (2025). Estimation of latent group structures in time-varying panel data models. \emph{arXiv preprint arXiv:2503.23165}. \doi{10.48550/arXiv.2503.23165}.
}
\author{
Paul Haimerl
}
