% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samples.R
\name{pt2_finetune}
\alias{pt2_finetune}
\alias{pt2_finetune<-}
\alias{pt2_volume}
\alias{pt2_volume<-}
\alias{pt2_loop_start}
\alias{pt2_loop_start<-}
\alias{pt2_loop_length}
\alias{pt2_loop_length<-}
\alias{pt2_is_looped}
\alias{pt2_is_looped<-}
\title{Get or set ProTracker sample properties}
\usage{
pt2_finetune(sample, ...)

pt2_finetune(sample, ...) <- value

pt2_volume(sample, ...)

pt2_volume(sample, ...) <- value

pt2_loop_start(sample, ...)

pt2_loop_start(sample, ...) <- value

pt2_loop_length(sample, ...)

pt2_loop_length(sample, ...) <- value

pt2_is_looped(sample, ...)

pt2_is_looped(sample, ...) <- value
}
\arguments{
\item{sample}{A module sample of class \code{pt2samp}.}

\item{...}{Ignored}

\item{value}{Replacement value for the sample property}
}
\value{
Returns an \code{integer} or \code{logical} value. Depending on the
called function. See the detail section for specifics.
}
\description{
Get or set properties of a ProTracker sample. See 'details' section
for available properties and associated functions.
}
\details{
ProTracker audio samples hold some meta data that affect their
playback. The following functions can be used to get or set these
properties:
\itemize{
\item \code{pt2_finetune()}: When a sample is out of tune, you can use the
use the 'finetune' value to tune the sample. It is an integer value
ranging between -8 and +7.
\item \code{pt2_volume()}: An integer value to adjust the sample volume. It ranges
between 0 (silent) to 64 (maximum volume).
\item \code{pt2_loop_start()} and \code{pt2_loop_length()}: defines if a sample is looped.
The loop start is defined as an even integer indicating the sample index
(zero based) where the loop should start. The loop length is the number
of samples, over which to loop. The loop length should also be an even
number greater than 0. The sum of the loop start and the loop length
should never be larger than the sample's length.
\item \code{pt2_is_looped()}: a \code{logical} value, indicating if the sample is looped.
If you set the loop status to \code{TRUE} when the sample is not looped yet,
the new loop will start at index 0, and will have a length equal to the
sample length.
}
}
\examples{
mod <- pt2_read_mod(pt2_demo())

pt2_finetune(mod$samples[[1]])
pt2_finetune(mod$samples[[1]]) <- -8L

pt2_volume(mod$samples[[2]])
pt2_volume(mod$samples[[2]]) <- 64L

pt2_loop_start(mod$samples[[1]])
pt2_loop_start(mod$samples[[1]]) <- 400L

pt2_loop_length(mod$samples[[1]])
pt2_loop_length(mod$samples[[1]]) <- 274L

pt2_is_looped(mod$samples[[2]])
pt2_is_looped(mod$samples[[2]]) <- TRUE
}
\seealso{
\code{\link[=pt2_name]{pt2_name()}}
}
