% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvt.R
\name{mvt}
\alias{mvt}
\alias{dmvt}
\alias{rmvt}
\title{Multivariate t distribution}
\usage{
dmvt(x, mu, Sigma, df, log = FALSE)

rmvt(n, mu, Sigma, df)
}
\arguments{
\item{x}{vector or matrix of quantiles}

\item{mu}{vector or matrix of location parameters (mean if \code{df} > 1)}

\item{Sigma}{positive definite scale matrix (proportional to the covariance matrix if \code{df} > 2)}

\item{df}{degrees of freedom; must be positive}

\item{log}{logical; if \code{TRUE}, densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{n}{number of random values to return.}
}
\value{
\code{dmvt} gives the density, \code{rmvt} generates random deviates.
}
\description{
Density and and random generation for the multivariate t distribution
}
\details{
This implementation of \code{dmvt} allows for automatic differentiation with \code{RTMB}.

Note: for \code{df} \eqn{\le 1} the mean is undefined, and for \code{df} \eqn{\le 2} the covariance is infinite.
For \code{df} > 2, the covariance is \code{df/(df-2) * Sigma}.
}
\examples{
# single mu
mu <- c(1,2,3)
Sigma <- diag(c(1,1,1))
df <- 5
x <- rmvt(2, mu, Sigma, df)
d <- dmvt(x, mu, Sigma, df)
# vectorised over mu
mu <- rbind(c(1,2,3), c(0, 0.5, 1))
x <- rmvt(2, mu, Sigma, df)
d <- dmvt(x, mu, Sigma, df)
}
