% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap02spd.R
\name{wrap.spd}
\alias{wrap.spd}
\title{Prepare Data on Symmetric Positive-Definite (SPD) Manifold}
\usage{
wrap.spd(input)
}
\arguments{
\item{input}{SPD data matrices to be wrapped as \code{riemdata} class. Following inputs are considered,
\describe{
\item{array}{an \eqn{(p\times p\times n)} array where each slice along 3rd dimension is a SPD matrix.}
\item{list}{a length-\eqn{n} list whose elements are \eqn{(p\times p)} SPD matrices.}
}}
}
\value{
a named \code{riemdata} S3 object containing
\describe{
  \item{data}{a list of \eqn{(p\times p)} SPD matrices.}
  \item{size}{size of each SPD matrix.}
  \item{name}{name of the manifold of interests, \emph{"spd"}}
}
}
\description{
The collection of symmetric positive-definite matrices is a well-known example 
of matrix manifold. It is defined as
\deqn{\mathcal{S}_{++}^p = \lbrace X \in \mathbf{R}^{p\times p} ~\vert~ X^\top = X,~ \textrm{rank}(X)=p \rbrace}
where the rank condition means it is strictly positive definite. Please note that 
the geometry involving semi-definite matrices is considered in \code{wrap.spdk}.
}
\examples{
#-------------------------------------------------------------------
#                 Checker for Two Types of Inputs
#
#  Generate 5 observations; empirical covariance of normal observations.
#-------------------------------------------------------------------
#  Data Generation
d1 = array(0,c(3,3,5))
d2 = list()
for (i in 1:5){
  dat = matrix(rnorm(10*3),ncol=3)
  d1[,,i] = stats::cov(dat)
  d2[[i]] = d1[,,i]
}

#  Run
test1 = wrap.spd(d1)
test2 = wrap.spd(d2)

}
\concept{wrapper}
