% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slotlim_once.R
\name{slotlim_once}
\alias{slotlim_once}
\title{slotlim_once}
\usage{
slotlim_once(
  Cy = NULL,
  b_index = NULL,
  method = c("annual", "1over2", "2over3"),
  minLS = NULL,
  maxLS = NULL,
  Lc = NULL,
  growth_model = c("vb", "gompertz", "schnute"),
  Linf = NULL,
  K = NULL,
  l0 = 0,
  tmax = NULL,
  Gom_Linf = NULL,
  Gom_K = NULL,
  Gom_l0 = NULL,
  g1 = NULL,
  g2 = NULL,
  l2 = NULL,
  M = NULL,
  lower = NULL,
  upper = NULL,
  LF = NULL,
  probs = c(0.025, 0.975),
  constraint = 1,
  T1 = NULL,
  T2 = NULL,
  plots = FALSE,
  length_units = NULL
)
}
\arguments{
\item{Cy}{Numeric. Historical catch.}

\item{b_index}{Numeric vector of a biomass or abundance index in descending time order
(most recent first).}

\item{method}{Character. Method for calculating \code{rb} ("annual", "1over2", or "2over3").}

\item{minLS, maxLS, Lc}{Numeric. Slot limits and length at first capture.}

\item{growth_model}{One of \code{"vb"}, \code{"gompertz"}, \code{"schnute"}.}

\item{Linf, K, l0}{von Bertalanffy (vB) parameters; \code{l0} is the start length (default 0).}

\item{tmax}{Numeric. Maximum observed age; used for integration bounds and (if \code{M} is \code{NULL})
to compute default \code{M}.}

\item{Gom_Linf, Gom_K, Gom_l0}{Gompertz parameters; requires \code{0 < Gom_l0 < Gom_Linf}.}

\item{g1, g2, l2}{Schnute parameters; \code{l2} is length at \code{tmax}; requires \code{g1 > 0}, \code{l2 > 0},
and this parameterization assumes \code{g2 != 0}.}

\item{M}{Numeric or \code{NULL}. Natural mortality. If \code{NULL}, defaults to \eqn{M = 4.899 \times tmax^{-0.916}}.}

\item{lower, upper}{Optional values at specified percentiles. If provided, used directly by \code{SAM()}.}

\item{LF}{Optional numeric vector of length-frequency data. If \code{lower}/\code{upper} are \code{NULL} and
\code{LF} is supplied, the function computes percentiles via \code{percentile(LF, probs)} and uses them.}

\item{probs}{Numeric vector of probabilities in \eqn{[0,1]} passed to \code{percentile()} when \code{LF} is used.
Default \code{c(0.025, 0.975)}.}

\item{constraint}{Numeric (default 1). Passed to \code{SAM()}.}

\item{T1, T2}{Optional numerics passed to \code{catch_advice()}.}

\item{plots}{Logical; if \code{TRUE}, a \eqn{2 \times 2} composite plot is printed (if \pkg{patchwork} is available).}

\item{length_units}{Optional character; x-axis units for the \code{prop_target} and \code{SAM} plots (e.g., "mm").}
}
\value{
A list with \code{Ay}, \code{Ay_percent}, \code{TBA}, \code{SAM}, \code{rb}, \code{P},
and (if \code{plots=TRUE}) a composite plot. Also returns the resolved \code{M} and the
\code{lower}/\code{upper} bounds actually used; \code{tmax} is echoed back.
}
\description{
Run a single SlotLim pass: compute \code{rb}, \code{P}, \code{TBA}, \code{SAM},
and catch advice \code{Ay_percent}; optionally show a composite plot (\code{P}, \code{TBA}, \code{SAM}, \code{Ay_percent}).
}
\details{
Precedence for size inputs: if both \code{lower} and \code{upper} are provided, they are used.
Otherwise, if \code{LF} is provided, they are derived via \code{percentile(LF, probs)}. Else error.
}
\examples{
# Minimal, fast example (no plotting), passing lower/upper directly:
slotlim_once(
  Cy = 1000,
  b_index = c(0.5, 0.6, 0.7, 0.6, 0.5), method = "2over3",
  minLS = 120, maxLS = 240, Lc = 80,
  growth_model = "vb", Linf = 405, K = 0.118, l0 = 0,
  tmax = 34,
  lower = 100, upper = 220
)

\donttest{
# Derive lower/upper from length-frequency percentiles:
set.seed(1)
LF <- rnorm(200, mean = 180, sd = 40)  # toy example LF

# Compute M from tmax:
slotlim_once(
  Cy = 1000,
  b_index = c(0.5, 0.6, 0.7, 0.6, 0.5),
  minLS = 120, maxLS = 240, Lc = 80,
  growth_model = "vb", Linf = 405, K = 0.118, l0 = 0,
  tmax = 34,
  LF = LF, probs = c(0.05, 0.95),
  method = "1over2"  # rb method chosen
)

# Use explicit M (still provide tmax for bounds):
slotlim_once(
  Cy = 1000,
  b_index = c(0.5, 0.6, 0.7, 0.6, 0.5),
  minLS = 120, maxLS = 240, Lc = 80,
  growth_model = "vb", Linf = 405, K = 0.118, l0 = 0,
  tmax = 34,
  M = 0.19,
  LF = LF, probs = c(0.025, 0.975),
  method = "1over2"  # rb method chosen
)

# Plotting example (needs ggplot2 and patchwork):
slotlim_once(
  Cy = 1000,
  b_index = c(0.5, 0.6, 0.7, 0.6, 0.5),
  minLS = 120, maxLS = 240, Lc = 80,
  growth_model = "vb", Linf = 405, K = 0.118, l0 = 0,
  tmax = 34,
  LF = LF, probs = c(0.025, 0.975),
  method = "1over2",  # rb method chosen
  plots = TRUE, length_units = "mm"
)
}

}
