% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_df_helpers.R
\name{as_exp_df}
\alias{as_exp_df}
\alias{is_exp_df}
\title{Termination summary helper functions}
\usage{
as_exp_df(
  x,
  expected = NULL,
  wt = NULL,
  col_claims,
  col_exposure,
  col_n_claims,
  col_weight_sq,
  col_weight_n,
  target_status = NULL,
  start_date = as.Date("1900-01-01"),
  end_date = NULL,
  credibility = FALSE,
  conf_level = 0.95,
  cred_r = 0.05,
  conf_int = FALSE
)

is_exp_df(x)
}
\arguments{
\item{x}{An object. For \code{as_exp_df()}, \code{x} must be a data frame.}

\item{expected}{A character vector containing column names in x with
expected values}

\item{wt}{Optional. Length 1 character vector. Name of the column in \code{x}
containing weights to use in the calculation of claims, exposures, partial
credibility, and confidence intervals.}

\item{col_claims}{Optional. Name of the column in \code{x} containing claims. The
assumed default is "claims".}

\item{col_exposure}{Optional. Name of the column in \code{x} containing exposures.
The assumed default is "exposure".}

\item{col_n_claims}{Optional and only used used when \code{wt} is passed. Name of
the column in \code{x} containing the number of claims.}

\item{col_weight_sq}{Optional and only used used when \code{wt} is passed. Name of
the column in \code{x} containing the sum of squared weights.}

\item{col_weight_n}{Optional and only used used when \code{wt} is passed. Name of
the column in \code{x} containing exposure record counts.}

\item{target_status}{Character vector of target status values. Default value
= \code{NULL}.}

\item{start_date}{Experience study start date. Default value = 1900-01-01.}

\item{end_date}{Experience study end date}

\item{credibility}{If \code{TRUE}, future calls to \code{\link[=summary]{summary()}} will include
partial credibility weights and credibility-weighted termination rates.}

\item{conf_level}{Confidence level used for the Limited Fluctuation
credibility method and confidence intervals}

\item{cred_r}{Error tolerance under the Limited Fluctuation credibility
method}

\item{conf_int}{If \code{TRUE}, future calls to \code{\link[=summary]{summary()}} will include
confidence intervals around the observed termination rates and any
actual-to-expected ratios.}
}
\value{
For \code{is_exp_df()}, a length-1 logical vector. For \code{as_exp_df()},
an \code{exp_df} object.
}
\description{
Convert aggregate termination experience studies to the \code{exp_df} class.
}
\details{
\code{is_exp_df()} will return \code{TRUE} if \code{x} is an \code{exp_df} object.

\code{as_exp_df()} will coerce a data frame to an \code{exp_df} object if that
data frame has columns for exposures and claims.

\code{as_exp_df()} is most useful for working with aggregate summaries of
experience that were not created by actxps where individual policy
information is not available. After converting the data to the \code{exp_df}
class, \code{\link[=summary]{summary()}} can be used to summarize data by any grouping variables,
and \code{\link[=autoplot]{autoplot()}} and \code{\link[=autotable]{autotable()}} are available for reporting.

If nothing is passed to \code{wt}, the data frame \code{x} must include columns
containing:
\itemize{
\item Exposures (\code{exposure})
\item Claim counts (\code{claims})
}

If \code{wt} is passed, the data must include columns containing:
\itemize{
\item Weighted exposures (\code{exposure})
\item Weighted claims (\code{claims})
\item Claim counts (\code{n_claims})
\item The raw sum of weights \strong{NOT} multiplied by exposures
\item Exposure record counts (\code{.weight_n})
\item The raw sum of squared weights (\code{.weight_sq})
}

The names in parentheses above are expected column names. If the data
frame passed to \code{as_exp_df()} uses different column names, these can be
specified using the \verb{col_*} arguments.

When a column name is passed to \code{wt}, the columns \code{.weight}, \code{.weight_n},
and \code{.weight_sq} are used to calculate credibility and confidence intervals.
If credibility and confidence intervals aren't required, then it is not
necessary to pass anything to \code{wt}. The results of \code{as_exp_df()} and any
downstream summaries will still be weighted as long as the exposures and
claims are pre-weighted.

\code{target_status}, \code{start_date}, and \code{end_date} are optional arguments that are
only used for printing the resulting \code{exp_df} object.
}
\examples{
# convert pre-aggregated experience into an exp_df object
dat <- as_exp_df(agg_sim_dat, col_exposure = "exposure_n",
                 col_claims = "claims_n",
                 target_status = "Surrender",
                 start_date = 2005, end_date = 2019,
                 conf_int = TRUE)
dat
is_exp_df(dat)

# summary by policy year
summary(dat, pol_yr)

# repeat the prior exercise on a weighted basis
dat_wt <- as_exp_df(agg_sim_dat, wt = "av",
                    col_exposure = "exposure_amt",
                    col_claims = "claims_amt",
                    col_n_claims = "claims_n",
                    col_weight_sq = "av_sq",
                    col_weight_n = "n",
                    target_status = "Surrender",
                    start_date = 2005, end_date = 2019,
                    conf_int = TRUE)
dat_wt

# summary by policy year
summary(dat_wt, pol_yr)


}
\seealso{
\code{\link[=exp_stats]{exp_stats()}} for information on how \code{exp_df} objects are typically
created from individual exposure records.
}
