% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obj_TEClassifierParallelPrototype.R
\name{TEClassifierParallelPrototype}
\alias{TEClassifierParallelPrototype}
\title{Text embedding classifier with a ProtoNet}
\value{
Returns a new object of this class ready for configuration or for loading
a saved classifier.
}
\description{
\strong{Classification Type}

This object is a metric based classifer and represents in implementation of a prototypical network for
few-shot learning as described by Snell,
Swersky, and Zemel (2017). The network uses a multi way contrastive loss described by Zhang et al. (2019). The
network learns to scale the metric as described by Oreshkin, Rodriguez, and Lacoste (2018).

\strong{Parallel Core Architecture}

This model is based on a parallel architecture.
An input is passed to different types of layers separately. At the end the outputs
are combined to create the final output of the whole model.

\strong{Transformer Encoder Layers}

\emph{Description}

The transformer encoder layers follow the structure of the encoder layers
used in transformer models. A single layer is designed as described by Chollet, Kalinowski, and Allaire (2022, p. 373) with
the exception that single components of the layers (such as the activation function,
the kind of residual connection, the kind of normalization or the kind of attention) can be customized. All parameters with the prefix \emph{tf_} can be used to configure this layer.

\strong{Feature Layer}

\emph{Description}

The feature layer is a dense layer that can be used to
increase or decrease the number of features of the input data before passing the
data into your model. The aim of this layer is to increase or reduce the complexity of the data for your model.
The output size of this layer determines the number of features for all following layers. In the special case that
the requested number of features equals the number of features of the text embeddings this layer
is reduced to a dropout layer with masking capabilities. All parameters with the prefix \emph{feat_} can be used to configure this layer.

\strong{Dense Layers}

\emph{Description}

A fully connected layer. The layer is applied to every step of a sequence. All parameters with the prefix \emph{dense_} can be used to configure this layer.

\strong{Multiple N-Gram Layers}

\emph{Description}

This type of layer focuses on sub-sequence and performs an 1d convolutional operation. On a word and token level
these sub-sequences can be interpreted as n-grams (Jacovi, Shalom & Goldberg 2018). The convolution is done across all features.
The number of filters equals the number of features of the input tensor. Thus, the shape of the tensor is retained (Pham, Kruszewski & Boleda 2016).

The layer is able to consider multiple n-grams at the same time. In this case the convolution of the n-grams is done
seprately and the resulting tensors are concatenated along the feature dimension. The number of filters for every n-gram
is set to num_features/num_n-grams. Thus, the resulting tensor has the same shape as the input tensor.

Sub-sequences that are masked in the input are
also masked in the output.

The output of this layer can be understand as the results of the n-gram filters. Stacking this layer
allows the model to perform n-gram detection of n-grams (meta perspective). All parameters with the prefix \emph{ng_conv_} can be used to configure this layer.

\strong{Recurrent Layers}

\emph{Description}

A regular recurrent layer either as Gated Recurrent Unit (GRU) or Long Short-Term Memory (LSTM) layer. Uses
PyTorchs implementation. All parameters with the prefix \emph{rec_} can be used to configure this layer.

\strong{Merge Layer}

\emph{Description}

Layer for combining the output of different layers. All inputs must be sequential data of shape (Batch, Times, Features).
First, pooling over time is applied extracting the minimal and/or maximal features.
Second, the pooled tensors are combined by calculating their weighted sum. Different attention mechanism can be used
to dynamically calculate the corresponding weights. This allows the model to decide which part of the data is most usefull.
Finally, pooling over features is applied extracting a specific number of maximal and/or minimal features. A normalization of all input
at the begining of the layer is possible. All parameters with the prefix \emph{merge_} can be used to configure this layer.

\strong{Training and Prediction}

For the creation and training of a
classifier an object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} on the one hand and a \link{factor} on
the other hand are necessary.

The object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings}  contains the numerical text representations
(text embeddings) of the raw texts generated by an object of class \link{TextEmbeddingModel}. For supporting large data
sets it is recommended to use \link{LargeDataSetForTextEmbeddings} instead of \link{EmbeddedText}.

The \code{factor} contains the classes/categories for every text. Missing values (unlabeled cases) are supported and can
be used for pseudo labeling.

For predictions an object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} has to be used which was
created with the same \link{TextEmbeddingModel} as for training.
}
\references{
Oreshkin, B. N., Rodriguez, P. & Lacoste, A. (2018). TADAM: Task dependent adaptive metric for improved
few-shot learning. https://doi.org/10.48550/arXiv.1805.10123

Snell, J., Swersky, K. & Zemel, R. S. (2017). Prototypical Networks for Few-shot Learning.
https://doi.org/10.48550/arXiv.1703.05175

Zhang, X., Nie, J., Zong, L., Yu, H. & Liang, W. (2019). One Shot Learning with Margin. In Q. Yang, Z.-H.
Zhou, Z. Gong, M.-L. Zhang & S.-J. Huang (Eds.), Lecture Notes in Computer Science. Advances in Knowledge Discovery
and Data Mining (Vol. 11440, pp. 305–317). Springer International Publishing.
https://doi.org/10.1007/978-3-030-16145-3_24
}
\seealso{
Other Classification: 
\code{\link{TEClassifierParallel}},
\code{\link{TEClassifierProtoNet}},
\code{\link{TEClassifierRegular}},
\code{\link{TEClassifierSequential}},
\code{\link{TEClassifierSequentialPrototype}}
}
\concept{Classification}
\section{Super classes}{
\code{\link[aifeducation:AIFEMaster]{aifeducation::AIFEMaster}} -> \code{\link[aifeducation:AIFEBaseModel]{aifeducation::AIFEBaseModel}} -> \code{\link[aifeducation:ModelsBasedOnTextEmbeddings]{aifeducation::ModelsBasedOnTextEmbeddings}} -> \code{\link[aifeducation:ClassifiersBasedOnTextEmbeddings]{aifeducation::ClassifiersBasedOnTextEmbeddings}} -> \code{\link[aifeducation:TEClassifiersBasedOnProtoNet]{aifeducation::TEClassifiersBasedOnProtoNet}} -> \code{TEClassifierParallelPrototype}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TEClassifierParallelPrototype-configure}{\code{TEClassifierParallelPrototype$configure()}}
\item \href{#method-TEClassifierParallelPrototype-clone}{\code{TEClassifierParallelPrototype$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_all_fields"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_all_fields'><code>aifeducation::AIFEMaster$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_documentation_license"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_documentation_license'><code>aifeducation::AIFEMaster$get_documentation_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_ml_framework"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_ml_framework'><code>aifeducation::AIFEMaster$get_ml_framework()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_model_config"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_model_config'><code>aifeducation::AIFEMaster$get_model_config()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_model_description"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_model_description'><code>aifeducation::AIFEMaster$get_model_description()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_model_info"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_model_info'><code>aifeducation::AIFEMaster$get_model_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_model_license"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_model_license'><code>aifeducation::AIFEMaster$get_model_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_package_versions"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_package_versions'><code>aifeducation::AIFEMaster$get_package_versions()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_private"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_private'><code>aifeducation::AIFEMaster$get_private()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_publication_info"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_publication_info'><code>aifeducation::AIFEMaster$get_publication_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="get_sustainability_data"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-get_sustainability_data'><code>aifeducation::AIFEMaster$get_sustainability_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="is_configured"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-is_configured'><code>aifeducation::AIFEMaster$is_configured()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="is_trained"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-is_trained'><code>aifeducation::AIFEMaster$is_trained()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="set_documentation_license"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-set_documentation_license'><code>aifeducation::AIFEMaster$set_documentation_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="set_model_description"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-set_model_description'><code>aifeducation::AIFEMaster$set_model_description()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="set_model_license"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-set_model_license'><code>aifeducation::AIFEMaster$set_model_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEMaster" data-id="set_publication_info"><a href='../../aifeducation/html/AIFEMaster.html#method-AIFEMaster-set_publication_info'><code>aifeducation::AIFEMaster$set_publication_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="count_parameter"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-count_parameter'><code>aifeducation::AIFEBaseModel$count_parameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ModelsBasedOnTextEmbeddings" data-id="get_text_embedding_model"><a href='../../aifeducation/html/ModelsBasedOnTextEmbeddings.html#method-ModelsBasedOnTextEmbeddings-get_text_embedding_model'><code>aifeducation::ModelsBasedOnTextEmbeddings$get_text_embedding_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ModelsBasedOnTextEmbeddings" data-id="get_text_embedding_model_name"><a href='../../aifeducation/html/ModelsBasedOnTextEmbeddings.html#method-ModelsBasedOnTextEmbeddings-get_text_embedding_model_name'><code>aifeducation::ModelsBasedOnTextEmbeddings$get_text_embedding_model_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="adjust_target_levels"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-adjust_target_levels'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$adjust_target_levels()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="check_embedding_model"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-check_embedding_model'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$check_embedding_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="check_feature_extractor_object_type"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-check_feature_extractor_object_type'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$check_feature_extractor_object_type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="load_from_disk"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-load_from_disk'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$load_from_disk()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="plot_coding_stream"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-plot_coding_stream'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$plot_coding_stream()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="plot_training_history"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-plot_training_history'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$plot_training_history()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="predict"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-predict'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="requires_compression"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-requires_compression'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$requires_compression()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="save"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-save'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="TEClassifiersBasedOnProtoNet" data-id="embed"><a href='../../aifeducation/html/TEClassifiersBasedOnProtoNet.html#method-TEClassifiersBasedOnProtoNet-embed'><code>aifeducation::TEClassifiersBasedOnProtoNet$embed()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="TEClassifiersBasedOnProtoNet" data-id="get_metric_scale_factor"><a href='../../aifeducation/html/TEClassifiersBasedOnProtoNet.html#method-TEClassifiersBasedOnProtoNet-get_metric_scale_factor'><code>aifeducation::TEClassifiersBasedOnProtoNet$get_metric_scale_factor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="TEClassifiersBasedOnProtoNet" data-id="plot_embeddings"><a href='../../aifeducation/html/TEClassifiersBasedOnProtoNet.html#method-TEClassifiersBasedOnProtoNet-plot_embeddings'><code>aifeducation::TEClassifiersBasedOnProtoNet$plot_embeddings()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="TEClassifiersBasedOnProtoNet" data-id="predict_with_samples"><a href='../../aifeducation/html/TEClassifiersBasedOnProtoNet.html#method-TEClassifiersBasedOnProtoNet-predict_with_samples'><code>aifeducation::TEClassifiersBasedOnProtoNet$predict_with_samples()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="TEClassifiersBasedOnProtoNet" data-id="train"><a href='../../aifeducation/html/TEClassifiersBasedOnProtoNet.html#method-TEClassifiersBasedOnProtoNet-train'><code>aifeducation::TEClassifiersBasedOnProtoNet$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierParallelPrototype-configure"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierParallelPrototype-configure}{}}}
\subsection{Method \code{configure()}}{
Creating a new instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierParallelPrototype$configure(
  name = NULL,
  label = NULL,
  text_embeddings = NULL,
  feature_extractor = NULL,
  target_levels = NULL,
  metric_type = "Euclidean",
  shared_feat_layer = TRUE,
  projection_type = "Regular",
  feat_act_fct = "ELU",
  feat_size = 50L,
  feat_bias = TRUE,
  feat_dropout = 0,
  feat_parametrizations = "None",
  feat_normalization_type = "LayerNorm",
  ng_conv_act_fct = "ELU",
  ng_conv_n_layers = 1L,
  ng_conv_ks_min = 2L,
  ng_conv_ks_max = 4L,
  ng_conv_bias = FALSE,
  ng_conv_dropout = 0.1,
  ng_conv_parametrizations = "None",
  ng_conv_normalization_type = "LayerNorm",
  ng_conv_residual_type = "ResidualGate",
  dense_act_fct = "ELU",
  dense_n_layers = 1L,
  dense_dropout = 0.5,
  dense_bias = FALSE,
  dense_parametrizations = "None",
  dense_normalization_type = "LayerNorm",
  dense_residual_type = "ResidualGate",
  rec_act_fct = "Tanh",
  rec_n_layers = 1L,
  rec_type = "GRU",
  rec_bidirectional = FALSE,
  rec_dropout = 0.2,
  rec_bias = FALSE,
  rec_parametrizations = "None",
  rec_normalization_type = "LayerNorm",
  rec_residual_type = "ResidualGate",
  tf_act_fct = "ELU",
  tf_dense_dim = 50L,
  tf_n_layers = 1L,
  tf_dropout_rate_1 = 0.1,
  tf_dropout_rate_2 = 0.5,
  tf_attention_type = "MultiHead",
  tf_positional_type = "absolute",
  tf_num_heads = 1L,
  tf_bias = FALSE,
  tf_parametrizations = "None",
  tf_normalization_type = "LayerNorm",
  tf_normalization_position = "Pre",
  tf_residual_type = "ResidualGate",
  merge_attention_type = "multi_head",
  merge_num_heads = 1L,
  merge_normalization_type = "LayerNorm",
  merge_pooling_features = 50L,
  merge_pooling_type = "MinMax",
  embedding_dim = 2L
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{string} Name of the new model. Please refer to common name conventions.
Free text can be used with parameter \code{label}. If set to \code{NULL} a unique ID
is generated automatically. Allowed values: any}

\item{\code{label}}{\code{string} Label for the new model. Here you can use free text. Allowed values: any}

\item{\code{text_embeddings}}{\verb{EmbeddedText, LargeDataSetForTextEmbeddings} Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings}.}

\item{\code{feature_extractor}}{\code{TEFeatureExtractor} Object of class \link{TEFeatureExtractor} which should be used in order to reduce
the number of dimensions of the text embeddings. If no feature extractor should be applied set \code{NULL}.}

\item{\code{target_levels}}{\code{vector} containing the levels (categories or classes) within the target data. Please
note that order matters. For ordinal data please ensure that the levels are sorted correctly with later levels
indicating a higher category/class. For nominal data the order does not matter.}

\item{\code{metric_type}}{\code{string} Type of metric used for calculating the distance. Allowed values: 'Euclidean', 'CosineDistance'}

\item{\code{shared_feat_layer}}{\code{bool} If \code{TRUE} all streams use the same feature layer. If \code{FALSE} all streams use their own feature layer.}

\item{\code{projection_type}}{\code{string} Type of projection. Allowed values: 'Regular', 'PairwiseOrthogonal', 'PairwiseOrthogonalDense'}

\item{\code{feat_act_fct}}{\code{string} Activation function for all layers. Allowed values: 'ELU', 'LeakyReLU', 'ReLU', 'GELU', 'Sigmoid', 'Tanh', 'PReLU'}

\item{\code{feat_size}}{\code{int} Number of neurons for each dense layer. Allowed values: \ifelse{latex}{$2 <= x $}{\ifelse{html}{\eqn{2 <= x }}{`2 <= x `}}}

\item{\code{feat_bias}}{\code{bool} If \code{TRUE} a bias term is added to all layers. If \code{FALSE} no bias term is added to the layers.}

\item{\code{feat_dropout}}{\code{double} determining the dropout for the dense projection of the feature layer. Allowed values: \ifelse{latex}{$0 <= x <= 0.6$}{\ifelse{html}{\eqn{0 <= x <= 0.6}}{`0 <= x <= 0.6`}}}

\item{\code{feat_parametrizations}}{\code{string} Re-Parametrizations of the weights of layers. Allowed values: 'None', 'OrthogonalWeights', 'WeightNorm', 'SpectralNorm'}

\item{\code{feat_normalization_type}}{\code{string} Type of normalization applied to all layers and stack layers. Allowed values: 'LayerNorm', 'None'}

\item{\code{ng_conv_act_fct}}{\code{string} Activation function for all layers. Allowed values: 'ELU', 'LeakyReLU', 'ReLU', 'GELU', 'Sigmoid', 'Tanh', 'PReLU'}

\item{\code{ng_conv_n_layers}}{\code{int} determining how many times the n-gram layers should be added to the network. Allowed values: \ifelse{latex}{$0 <= x $}{\ifelse{html}{\eqn{0 <= x }}{`0 <= x `}}}

\item{\code{ng_conv_ks_min}}{\code{int} determining the minimal window size for n-grams. Allowed values: \ifelse{latex}{$2 <= x $}{\ifelse{html}{\eqn{2 <= x }}{`2 <= x `}}}

\item{\code{ng_conv_ks_max}}{\code{int} determining the maximal window size for n-grams. Allowed values: \ifelse{latex}{$2 <= x $}{\ifelse{html}{\eqn{2 <= x }}{`2 <= x `}}}

\item{\code{ng_conv_bias}}{\code{bool} If \code{TRUE} a bias term is added to all layers. If \code{FALSE} no bias term is added to the layers.}

\item{\code{ng_conv_dropout}}{\code{double} determining the dropout for n-gram convolution layers. Allowed values: \ifelse{latex}{$0 <= x <= 0.6$}{\ifelse{html}{\eqn{0 <= x <= 0.6}}{`0 <= x <= 0.6`}}}

\item{\code{ng_conv_parametrizations}}{\code{string} Re-Parametrizations of the weights of layers. Allowed values: 'None', 'OrthogonalWeights', 'WeightNorm', 'SpectralNorm'}

\item{\code{ng_conv_normalization_type}}{\code{string} Type of normalization applied to all layers and stack layers. Allowed values: 'LayerNorm', 'None'}

\item{\code{ng_conv_residual_type}}{\code{string} Type of residual connenction for all layers and stack of layers. Allowed values: 'ResidualGate', 'Addition', 'None'}

\item{\code{dense_act_fct}}{\code{string} Activation function for all layers. Allowed values: 'ELU', 'LeakyReLU', 'ReLU', 'GELU', 'Sigmoid', 'Tanh', 'PReLU'}

\item{\code{dense_n_layers}}{\code{int} Number of dense layers. Allowed values: \ifelse{latex}{$0 <= x $}{\ifelse{html}{\eqn{0 <= x }}{`0 <= x `}}}

\item{\code{dense_dropout}}{\code{double} determining the dropout between dense layers. Allowed values: \ifelse{latex}{$0 <= x <= 0.6$}{\ifelse{html}{\eqn{0 <= x <= 0.6}}{`0 <= x <= 0.6`}}}

\item{\code{dense_bias}}{\code{bool} If \code{TRUE} a bias term is added to all layers. If \code{FALSE} no bias term is added to the layers.}

\item{\code{dense_parametrizations}}{\code{string} Re-Parametrizations of the weights of layers. Allowed values: 'None', 'OrthogonalWeights', 'WeightNorm', 'SpectralNorm'}

\item{\code{dense_normalization_type}}{\code{string} Type of normalization applied to all layers and stack layers. Allowed values: 'LayerNorm', 'None'}

\item{\code{dense_residual_type}}{\code{string} Type of residual connenction for all layers and stack of layers. Allowed values: 'ResidualGate', 'Addition', 'None'}

\item{\code{rec_act_fct}}{\code{string} Activation function for all layers. Allowed values: 'Tanh'}

\item{\code{rec_n_layers}}{\code{int} Number of recurrent layers. Allowed values: \ifelse{latex}{$0 <= x $}{\ifelse{html}{\eqn{0 <= x }}{`0 <= x `}}}

\item{\code{rec_type}}{\code{string} Type of the recurrent layers. \code{rec_type='GRU'} for Gated Recurrent Unit and \code{rec_type='LSTM'} for Long Short-Term Memory. Allowed values: 'GRU', 'LSTM'}

\item{\code{rec_bidirectional}}{\code{bool} If \code{TRUE} a bidirectional version of the recurrent layers is used.}

\item{\code{rec_dropout}}{\code{double} determining the dropout between recurrent layers. Allowed values: \ifelse{latex}{$0 <= x <= 0.6$}{\ifelse{html}{\eqn{0 <= x <= 0.6}}{`0 <= x <= 0.6`}}}

\item{\code{rec_bias}}{\code{bool} If \code{TRUE} a bias term is added to all layers. If \code{FALSE} no bias term is added to the layers.}

\item{\code{rec_parametrizations}}{\code{string} Re-Parametrizations of the weights of layers. Allowed values: 'None'}

\item{\code{rec_normalization_type}}{\code{string} Type of normalization applied to all layers and stack layers. Allowed values: 'LayerNorm', 'None'}

\item{\code{rec_residual_type}}{\code{string} Type of residual connenction for all layers and stack of layers. Allowed values: 'ResidualGate', 'Addition', 'None'}

\item{\code{tf_act_fct}}{\code{string} Activation function for all layers. Allowed values: 'ELU', 'LeakyReLU', 'ReLU', 'GELU', 'Sigmoid', 'Tanh', 'PReLU'}

\item{\code{tf_dense_dim}}{\code{int} determining the size of the projection layer within a each transformer encoder. Allowed values: \ifelse{latex}{$1 <= x $}{\ifelse{html}{\eqn{1 <= x }}{`1 <= x `}}}

\item{\code{tf_n_layers}}{\code{int} determining how many times the encoder should be added to the network. Allowed values: \ifelse{latex}{$0 <= x $}{\ifelse{html}{\eqn{0 <= x }}{`0 <= x `}}}

\item{\code{tf_dropout_rate_1}}{\code{double} determining the dropout after the attention mechanism within the transformer encoder layers. Allowed values: \ifelse{latex}{$0 <= x <= 0.6$}{\ifelse{html}{\eqn{0 <= x <= 0.6}}{`0 <= x <= 0.6`}}}

\item{\code{tf_dropout_rate_2}}{\code{double} determining the dropout for the dense projection within the transformer encoder layers. Allowed values: \ifelse{latex}{$0 <= x <= 0.6$}{\ifelse{html}{\eqn{0 <= x <= 0.6}}{`0 <= x <= 0.6`}}}

\item{\code{tf_attention_type}}{\code{string} Choose the attention type. Allowed values: 'Fourier', 'MultiHead'}

\item{\code{tf_positional_type}}{\code{string} Type of processing positional information. Allowed values: 'None', 'absolute'}

\item{\code{tf_num_heads}}{\code{int} determining the number of attention heads for a self-attention layer. Only relevant if \code{attention_type='multihead'} Allowed values: \ifelse{latex}{$0 <= x $}{\ifelse{html}{\eqn{0 <= x }}{`0 <= x `}}}

\item{\code{tf_bias}}{\code{bool} If \code{TRUE} a bias term is added to all layers. If \code{FALSE} no bias term is added to the layers.}

\item{\code{tf_parametrizations}}{\code{string} Re-Parametrizations of the weights of layers. Allowed values: 'None', 'OrthogonalWeights', 'WeightNorm', 'SpectralNorm'}

\item{\code{tf_normalization_type}}{\code{string} Type of normalization applied to all layers and stack layers. Allowed values: 'LayerNorm', 'None'}

\item{\code{tf_normalization_position}}{\code{string} Position where the normalization should be applied. Allowed values: 'Pre', 'Post'}

\item{\code{tf_residual_type}}{\code{string} Type of residual connenction for all layers and stack of layers. Allowed values: 'ResidualGate', 'Addition', 'None'}

\item{\code{merge_attention_type}}{\code{string} Choose the attention type. Allowed values: 'Fourier', 'MultiHead'}

\item{\code{merge_num_heads}}{\code{int} determining the number of attention heads for a self-attention layer. Only relevant if \code{attention_type='multihead'} Allowed values: \ifelse{latex}{$0 <= x $}{\ifelse{html}{\eqn{0 <= x }}{`0 <= x `}}}

\item{\code{merge_normalization_type}}{\code{string} Type of normalization applied to all layers and stack layers. Allowed values: 'LayerNorm', 'None'}

\item{\code{merge_pooling_features}}{\code{int} Number of features to be extracted at the end of the model. Allowed values: \ifelse{latex}{$1 <= x $}{\ifelse{html}{\eqn{1 <= x }}{`1 <= x `}}}

\item{\code{merge_pooling_type}}{\code{string} Type of extracting intermediate features. Allowed values: 'Max', 'Min', 'MinMax'}

\item{\code{embedding_dim}}{\code{int}  determining the number of dimensions for the embedding. Allowed values: \ifelse{latex}{$2 <= x $}{\ifelse{html}{\eqn{2 <= x }}{`2 <= x `}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does nothing return. It modifies the current object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierParallelPrototype-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierParallelPrototype-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierParallelPrototype$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
