% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCambicBounds.R
\name{getCambicBounds}
\alias{getCambicBounds}
\title{Find all intervals that are potentially part of a Cambic horizon}
\usage{
getCambicBounds(
  p,
  hzdesgn = hzdesgnname(p, required = TRUE),
  texcl.attr = hztexclname(p, required = TRUE),
  clay.attr = hzmetaname(p, "clay", required = TRUE),
  argi_bounds = NULL,
  d_value = "d_value",
  m_value = "m_value",
  m_chroma = "m_chroma",
  sandy.texture.pattern = "-S$|^S$|COS$|L[^V]FS$|[^L]VFS$|LS$|LFS$",
  ...
)
}
\arguments{
\item{p}{A single-profile SoilProfileCollection}

\item{hzdesgn}{Column name containing horizon designations.}

\item{texcl.attr}{Arguments to \code{getArgillicBounds()}}

\item{clay.attr}{Arguments to \code{getArgillicBounds()}}

\item{argi_bounds}{Optional: numeric vector of length 2 with top and bottom of argillic; (Default: NULL)}

\item{d_value}{Column name containing dry value. Default: d_value}

\item{m_value}{Column name containing moist value. Default: m_value}

\item{m_chroma}{Column name containing moist chroma Default: m_chroma}

\item{sandy.texture.pattern}{this is a pattern for matching sandy textural classes: \verb{-S$|^S$|COS$|L[^V]FS$|[^L]VFS$|LS$|LFS$}}

\item{...}{Arguments to \code{getArgillicBounds()}}
}
\value{
A \code{data.frame} containing profile, cambic indexes, along with top and bottom depths.
}
\description{
Find all intervals that are potentially part of a Cambic horizon excluding those that are part of an argillic horizon (defined either by depth interval or \code{getArgillicBounds()}).

There may be multiple cambic horizons (indexes) in a profile. Each cambic index has a top and bottom depth associated: cambic_top and cambic_bottom. This result is designed to be used for single profiles, or with \code{profileApply(..., frameify = TRUE)}
}
\examples{
# construct a fake profile
spc <- data.frame(id=1, taxsubgrp = "Lithic Haploxerepts",
                  hzname   = c("A","AB","Bw","BC","R"),
                  hzdept   = c(0,  20, 32, 42,  49),
                  hzdepb   = c(20, 32, 42, 49, 200),
                  clay     = c(19, 22, 22, 21,  NA),
                  texcl    = c("l","l","l", "l","br"),
                  d_value  = c(5,   5,  5,  6,  NA),
                  m_value  = c(2.5, 3,  3,  4,  NA),
                  m_chroma = c(2,   3,  4,  4,  NA))

# promote to SoilProfileCollection
depths(spc) <- id ~ hzdept + hzdepb

# set required metadata
hzdesgnname(spc) <- 'hzname'
hztexclname(spc) <- 'texcl'
hzmetaname(spc, 'clay') <- 'clay'

# print results in table
getCambicBounds(spc)

}
\author{
Andrew G. Brown
}
