% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-url.R
\name{url}
\alias{url}
\alias{arc_url_parse}
\alias{arc_url_type}
\alias{is_url}
\title{Parse an ArcGIS service or content URL into its components}
\usage{
arc_url_parse(url, base_url = NULL, error_call = rlang::caller_call())

arc_url_type(url, error_call = rlang::caller_call())

is_url(url, error_call = rlang::caller_call())
}
\arguments{
\item{url}{A string containing the URL to parse.}

\item{base_url}{Use this as a parent, if \code{url} is a relative URL.}

\item{error_call}{the caller environment to be used when propagating errors.}
}
\value{
A named list with the following components: scheme, hostname, username, password, port, path, query, fragment, url, type, and layer.
}
\description{
\code{\link[=arc_url_parse]{arc_url_parse()}} uses \code{\link[httr2:url_parse]{httr2::url_parse()}} to parse URL components and
combine the components with a service or content URL \code{type} and a \code{layer}
number if applicable. A \code{layer} component is only included if the \code{type} is \code{"MapServer"} or
\code{"FeatureServer"} and the URL includes a trailing digit. A full \code{url} value is
also included in the returned list. The \code{url}, \code{type}, and \code{layer} components
are not part of the \code{httr2_url} class object returned by
\code{\link[httr2:url_parse]{httr2::url_parse()}}.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
arc_url_parse(
  "https://services.arcgisonline.com/arcgis/rest/services/USA_Topo_Maps/MapServer/0"
)
arc_url_parse(
  "https://geocode.arcgis.com/arcgis/rest/services/World/GeocodeServer"
)
arc_url_parse(
  "https://services.arcgisonline.com/arcgis/rest/services/WorldElevation3D/Terrain3D/ImageServer"
)

}
