% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.recode.pop.r
\name{gl.recode.pop}
\alias{gl.recode.pop}
\title{Recodes population assignments in a genlight object}
\usage{
gl.recode.pop(x, pop.recode, recalc = FALSE, mono.rm = FALSE, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{pop.recode}{Name of the csv file containing the population
reassignments [required].}

\item{recalc}{If TRUE, recalculates the locus metadata statistics if any individuals
are deleted in the filtering [default FALSE].}

\item{mono.rm}{If TRUE, removes monomorphic loci [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2, 
progress log; 3, progress and results summary; 5, full report 
[default 2 or as specified using gl.set.verbosity].}
}
\value{
A genlight object with the recoded and reduced data.
}
\description{
This function recodes population assignments and/or deletes populations from a
DaRT genlight object based on information provided in a csv population
recode file.
}
\details{
Individuals are assigned to populations based on the specimen metadata data
file (csv) used with gl.read.dart(). Recoding can be used to amalgamate
populations or to selectively delete or retain populations.
When caution needs to be exercised because of the potential for breaking the
'chain of evidence' associated with the samples, recoding individuals using
a recode table (csv) can provide a durable record of the changes.
The population recode file contains a list of populations taken from the genlight
 object as the first column of the csv file, and the new population
 assignments are located in the second column of the csv file. The keyword 
 'Delete' used as a new population assignment will result in the associated 
 specimen being dropped from the dataset.
The function works with genlight objects
containing SNP genotypes and Tag P/A data (SilicoDArT).
For SNP genotype data, the function, having deleted populations, optionally 
identifies resultant monomorphic loci or loci with all values missing 
and deletes them. The script also optionally recalculates the
locus metadata as appropriate. The optional deletion of monomorphic loci
and the optional recalculation of locus statistics is not available for
Tag P/A data (SilicoDArT).
}
\examples{
\donttest{
  mfile <- system.file('extdata', 'testset_pop_recode.csv', package='dartR.data')
  nPop(testset.gl)
  gl <- gl.recode.pop(testset.gl, pop.recode=mfile, verbose=3)
 }
}
\seealso{
\code{\link{gl.filter.monomorphs}}

\code{\link{gl.recode.pop}}

Other data manipulation: 
\code{\link{gl.define.pop}()},
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.join}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.merge.pop}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.rename.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sim.genotypes}()},
\code{\link{gl.sort}()},
\code{\link{gl.subsample.ind}()},
\code{\link{gl.subsample.loc}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{data manipulation}
