% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difORD.R
\name{coef.difORD}
\alias{coef.difORD}
\alias{coefficients.difORD}
\title{Extract model coefficients from an object of \code{"difORD"} class.}
\usage{
\method{coef}{difORD}(object, SE = FALSE, simplify = FALSE, IRTpars = TRUE, CI = 0.95, ...)
}
\arguments{
\item{object}{an object of \code{"difORD"} class.}

\item{SE}{logical: should the standard errors of estimated
parameters be also returned? (default is \code{FALSE}).}

\item{simplify}{logical: should the estimated parameters be
simplified to a matrix? (default is \code{FALSE}).}

\item{IRTpars}{logical: should the estimated parameters be returned
in IRT parameterization? (default is \code{TRUE}).}

\item{CI}{numeric: level of confidence interval for parameters,
default is \code{0.95} for 95\% confidence interval.}

\item{...}{other generic parameters for \code{coef()} function.}
}
\description{
S3 method for extracting estimated model coefficients
  from an object of \code{"difORD"} class.
}
\examples{
\dontrun{
# loading data
data(Anxiety, package = "ShinyItemAnalysis")
Data <- Anxiety[, paste0("R", 1:29)] # items
group <- Anxiety[, "gender"] # group membership variable

# testing both DIF effects with adjacent category logit model
(x <- difORD(Data, group, focal.name = 1, model = "adjacent"))

# estimated parameters
coef(x)
# includes standard errors
coef(x, SE = TRUE)
# includes standard errors and simplifies to matrix
coef(x, SE = TRUE, simplify = TRUE)
# intercept-slope parameterization
coef(x, IRTpars = FALSE)
# intercept-slope parameterization, simplifies to matrix, turn off confidence intervals
coef(x, IRTpars = FALSE, simplify = TRUE, CI = 0)
}
}
\seealso{
\code{\link[difNLR]{difORD}} for DIF detection among ordinal data. \cr
\code{\link[stats]{coef}} for generic function extracting model coefficients.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
