% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igb_standardsDS.R
\name{igb_standardsDS}
\alias{igb_standardsDS}
\title{Converts birth measurements to intergrowth z-scores/centiles}
\usage{
igb_standardsDS(
  gagebrth = gagebrth,
  z = z,
  p = p,
  val = val,
  var = var,
  sex = sex,
  fun = fun
)
}
\arguments{
\item{gagebrth}{the name of the "gestational age at birth in days" variable.}

\item{z}{z-score(s) to convert (must be between 0 and 1). Default value is 0.
This value is used only if \code{fun} is set to "igb_zscore2value".}

\item{p}{centile(s) to convert (must be between 0 and 100). Default value is p=50. 
This value is used only if \code{fun} is set to "igb_centile2value".}

\item{val}{the name of the anthropometric variable to convert.}

\item{var}{the name of the measurement to convert ("lencm", "wtkg", "hcircm", "wlr")}

\item{sex}{the name of the sex factor variable. The variable should be coded as Male/Female.
If it is coded differently (e.g. 0/1), then you can use the ds.recodeValues function to 
recode the categories to Male/Female before the use of ds.igb_standards}

\item{fun}{the name of the function to be used. This can be one of: "igb_centile2value",
"igb_zscore2value", "igb_value2zscore" (default), "igb_value2centile".}
}
\value{
assigns the converted measurement as a new object on the server-side
}
\description{
Converts birth measurements to INTERGROWTH z-scores/centiles (generic)
}
\note{
For gestational ages between 24 and 33 weeks, the INTERGROWTH very early preterm 
standard is used.
}
\author{
Demetris Avraam for DataSHIELD Development Team
}
