% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{Dimensionality}
\alias{Dimensionality}
\alias{Dimensionality.default}
\alias{Dimensionality.binary}
\alias{Dimensionality.rated}
\alias{Dimensionality.ordinal}
\title{Dimensionality}
\usage{
Dimensionality(U, na = NULL, Z = NULL, w = NULL)

\method{Dimensionality}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{Dimensionality}{binary}(U, na = NULL, Z = NULL, w = NULL)

\method{Dimensionality}{rated}(U, na = NULL, Z = NULL, w = NULL)

\method{Dimensionality}{ordinal}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
Returns a list of class c("exametrika", "Dimensionality") containing:
\describe{
\item{Component}{Sequence of component numbers}
\item{Eigenvalue}{Eigenvalues of the tetrachoric correlation matrix}
\item{PerOfVar}{Percentage of variance explained by each component}
\item{CumOfPer}{Cumulative percentage of variance explained}
}
}
\description{
The dimensionality is the number of components
the test is measuring.
}
