% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_performance.R
\name{plot.light_performance}
\alias{plot.light_performance}
\title{Visualize Model Performance}
\usage{
\method{plot}{light_performance}(
  x,
  swap_dim = FALSE,
  geom = c("bar", "point"),
  facet_scales = "free_y",
  rotate_x = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class "light_performance".}

\item{swap_dim}{Should representation of dimensions
(either two "by" variables or one "by" variable and multiflashlight)
of x aesthetic and dodge fill aesthetic be swapped? Default is \code{FALSE}.}

\item{geom}{Geometry of plot (either "bar" or "point")}

\item{facet_scales}{Scales argument passed to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.}

\item{rotate_x}{Should x axis labels be rotated by 45 degrees?}

\item{...}{Further arguments passed to \code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}} or
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}
}
\value{
An object of class "ggplot".
}
\description{
Minimal visualization of an object of class "light_performance" as
\code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}}. The object returned has class "ggplot",
and can be further customized.
}
\details{
The plot is organized as a bar plot as follows:
For flashlights without "by" variable specified, a single bar is drawn.
Otherwise, the "by" variable (or the flashlight label if there is no "by" variable)
is represented by the "x" aesthetic.

The flashlight label (in case of one "by" variable) is represented by dodged bars.
This strategy makes sure that performance of different flashlights can
be compared easiest. Set "swap_dim = TRUE" to revert the role of dodging and x
aesthetic. Different metrics are always represented by facets.
}
\seealso{
\code{\link[=light_performance]{light_performance()}}
}
