% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hce.R
\name{hce}
\alias{hce}
\title{Helper function for \code{hce} objects}
\usage{
hce(GROUP, TRTP, AVAL0 = NULL, PADY = NULL)
}
\arguments{
\item{GROUP}{a character vector or a factor containing events.
If a factor, its levels are used to define the hierarchy. Otherwise, the vector is
converted to a factor.}

\item{TRTP}{a character vector of the same length as \code{GROUP}, indicating assigned treatment groups.}

\item{AVAL0}{a numeric vector of the same length as \code{GROUP}, indicating containing analysis values within each category. The default is 0.}

\item{PADY}{numeric specifying the length of follow-up in years.}
}
\value{
an object of class \code{hce} or \code{adhce} (if \code{AVAL0} is provided). The result
is a subject-level data frame, where each row corresponds to one subject,
}
\description{
Helper function for \code{hce} objects
}
\examples{
# Example 1 - Both `AVAL0` and `PADY` are provided. The output is an `adhce` object.
GROUP <- COVID19$GROUP
TRTP <- rep(c("A", "P"), each = 531)
dat <- hce(GROUP, TRTP, PADY = 10, AVAL0 = rnorm(1062))
class(dat)
calcWO(dat)
summaryWO(dat) # Uses the `GROUP` variable for summary.
# Example 2 - Only `AVAL0` is provided, `PADY` is calculated as the maximum of `AVAL0`. 
# The output is an `adhce` object.
set.seed(2022)
d <- hce(GROUP = sample(x = c("A", "B", "C"), size = 10, replace = TRUE), 
TRTP = rep(c("Active", "Control"), each = 5), 
AVAL0 = c(rnorm(5, mean = 1), rnorm(5)))
calcWO(d, ref = "Control")
## modify the hierarchy by proving a factor for the GROUP variable. 
## calcWO() applied to an hce rederives `AVAL` based on the `GROUP` variable.
d$GROUP <- factor(d$GROUP, levels = c("C", "B", "A"))
calcWO(d, ref = "Control")
# Example 3 - Provide only `PADY` and not `AVAL0` will not make any difference.
GROUP <- COVID19$GROUP
TRTP <- rep(c("A", "P"), each = 531)
dat <- hce(GROUP, TRTP, PADY = 10)
class(dat)
calcWO(dat)
dat <- hce(GROUP, TRTP)
class(dat)
calcWO(dat)
}
\seealso{
\code{\link[=as_hce]{as_hce()}} for coercing to \code{hce} objects.
}
