% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_with_fr}
\alias{layout_with_fr}
\alias{with_fr}
\title{The Fruchterman-Reingold layout algorithm}
\usage{
layout_with_fr(
  graph,
  coords = NULL,
  dim = c(2, 3),
  niter = 500,
  start.temp = sqrt(vcount(graph)),
  grid = c("auto", "grid", "nogrid"),
  weights = NULL,
  minx = NULL,
  maxx = NULL,
  miny = NULL,
  maxy = NULL,
  minz = NULL,
  maxz = NULL,
  coolexp = deprecated(),
  maxdelta = deprecated(),
  area = deprecated(),
  repulserad = deprecated(),
  maxiter = deprecated()
)

with_fr(...)
}
\arguments{
\item{graph}{The graph to lay out. Edge directions are ignored.}

\item{coords}{Optional starting positions for the vertices. If this argument
is not \code{NULL} then it should be an appropriate matrix of starting
coordinates.}

\item{dim}{Integer scalar, 2 or 3, the dimension of the layout.  Two
dimensional layouts are places on a plane, three dimensional ones in the 3d
space.}

\item{niter}{Integer scalar, the number of iterations to perform.}

\item{start.temp}{Real scalar, the start temperature. This is the maximum
amount of movement alloved along one axis, within one step, for a vertex.
Currently it is decreased linearly to zero during the iteration.}

\item{grid}{Character scalar, whether to use the faster, but less accurate
grid based implementation of the algorithm. By default (\dQuote{auto}), the
grid-based implementation is used if the graph has more than one thousand
vertices.}

\item{weights}{A vector giving edge weights. The \code{weight} edge
attribute is used by default, if present. If weights are given, then the
attraction along the edges will be multiplied by the given edge weights.
This places vertices connected with a highly weighted edge closer to
each other. Weights must be positive.}

\item{minx}{If not \code{NULL}, then it must be a numeric vector that gives
lower boundaries for the \sQuote{x} coordinates of the vertices. The length
of the vector must match the number of vertices in the graph.}

\item{maxx}{Similar to \code{minx}, but gives the upper boundaries.}

\item{miny}{Similar to \code{minx}, but gives the lower boundaries of the
\sQuote{y} coordinates.}

\item{maxy}{Similar to \code{minx}, but gives the upper boundaries of the
\sQuote{y} coordinates.}

\item{minz}{Similar to \code{minx}, but gives the lower boundaries of the
\sQuote{z} coordinates.}

\item{maxz}{Similar to \code{minx}, but gives the upper boundaries of the
\sQuote{z} coordinates.}

\item{coolexp, maxdelta, area, repulserad}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} These
arguments are not supported from igraph version 0.8.0 and are ignored
(with a warning).}

\item{maxiter}{A deprecated synonym of \code{niter}, for compatibility.}

\item{...}{Passed to \code{layout_with_fr()}.}
}
\value{
A two- or three-column matrix, each row giving the coordinates of a
vertex, according to the ids of the vertex ids.
}
\description{
Place vertices on the plane using the force-directed layout algorithm by
Fruchterman and Reingold.
}
\details{
See the referenced paper below for the details of the algorithm.

This function was rewritten from scratch in igraph version 0.8.0.
}
\examples{

# Fixing ego
g <- sample_pa(20, m = 2)
minC <- rep(-Inf, vcount(g))
maxC <- rep(Inf, vcount(g))
minC[1] <- maxC[1] <- 0
co <- layout_with_fr(g,
  minx = minC, maxx = maxC,
  miny = minC, maxy = maxC
)
co[1, ]
plot(g,
  layout = co, vertex.size = 30, edge.arrow.size = 0.2,
  vertex.label = c("ego", rep("", vcount(g) - 1)), rescale = FALSE,
  xlim = range(co[, 1]), ylim = range(co[, 2]), vertex.label.dist = 0,
  vertex.label.color = "red"
)
axis(1)
axis(2)

}
\references{
Fruchterman, T.M.J. and Reingold, E.M. (1991). Graph Drawing by
Force-directed Placement. \emph{Software - Practice and Experience},
21(11):1129-1164.
}
\seealso{
\code{\link[=layout_with_drl]{layout_with_drl()}}, \code{\link[=layout_with_kk]{layout_with_kk()}} for
other layout algorithms.

Other graph layouts: 
\code{\link{add_layout_}()},
\code{\link{component_wise}()},
\code{\link{layout_}()},
\code{\link{layout_as_bipartite}()},
\code{\link{layout_as_star}()},
\code{\link{layout_as_tree}()},
\code{\link{layout_in_circle}()},
\code{\link{layout_nicely}()},
\code{\link{layout_on_grid}()},
\code{\link{layout_on_sphere}()},
\code{\link{layout_randomly}()},
\code{\link{layout_with_dh}()},
\code{\link{layout_with_gem}()},
\code{\link{layout_with_graphopt}()},
\code{\link{layout_with_kk}()},
\code{\link{layout_with_lgl}()},
\code{\link{layout_with_mds}()},
\code{\link{layout_with_sugiyama}()},
\code{\link{merge_coords}()},
\code{\link{norm_coords}()},
\code{\link{normalize}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{graph layouts}
\keyword{graphs}
