% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number.R
\name{inline_number}
\alias{inline_number}
\title{Inline number input}
\usage{
inline_number(
  id,
  value,
  min = NULL,
  max = NULL,
  step = NULL,
  default = value,
  placeholder = "Enter number",
  meaning = NULL
)
}
\arguments{
\item{id}{The \code{input} slot that will be used to access the value.}

\item{value}{The initial number.}

\item{min, max}{Minimum and maximum values. Use \code{NULL} for no limit.}

\item{step}{A step value for incrementing and decrementing the number using
the up or down arrow keys or with the clickable arrows on the widget. The
Page Up and Page Down keys increment or decrement the number by 10 steps,
and the Home and End keys set the number to the minimum or maximum
respectively. The default step is 1.}

\item{default}{A default value to be used if the input is invalid or empty.}

\item{placeholder}{The character string or HTML element that will appear in
the textbox when it is empty, as a prompt.}

\item{meaning}{A descriptive label, for people using assistive technology
such as screen readers.}
}
\value{
An inline widget to be included in an \code{\link[=inline]{inline()}} wrapper.
}
\description{
A single line numeric input similar to \code{\link[shiny:numericInput]{shiny::numericInput()}} that can be
included in an \code{\link[=inline]{inline()}} wrapper.
}
\examples{
ui <- bslib::page_fixed(
    shiny::h1("Breakfast app (beta)"),
    inline("Make me an omelette with ",
        inline_number("eggs", 6, min = 2, max = 12, step = 1,
            placeholder = "6 (default)", meaning = "Number of eggs"),
        " eggs.")
)
}
\seealso{
\link[shiny:numericInput]{shiny::numericInput} for how the number input works with your Shiny server.
}
