% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_utilities.R
\name{is_grouped}
\alias{is_grouped}
\title{Check if \code{mcc} object is from grouped analysis}
\usage{
is_grouped(x)
}
\arguments{
\item{x}{An \code{mcc} object}
}
\value{
Logical indicating whether the analysis was grouped
}
\description{
Check if \code{mcc} object is from grouped analysis
}
\examples{
# Create sample data
library(dplyr)
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 8, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 0, 1, 2),
  group = c("A", "A", "B", "B", "B", "B", "B", "A", "A")
) |>
  arrange(id, time)

# Ungrouped analysis
mcc_ungrouped <- mcc(df, "id", "time", "cause")
is_grouped(mcc_ungrouped)  # FALSE

# Grouped analysis
mcc_grouped <- mcc(df, "id", "time", "cause", by = "group")
is_grouped(mcc_grouped)  # TRUE

# Clean up
rm(df, mcc_ungrouped, mcc_grouped)

}
