% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{plot_normtable}
\alias{plot_normtable}
\title{Plot norm curves from a NormTable object}
\usage{
plot_normtable(
  normtable,
  lty = 1,
  lwd = 3,
  pch = 1,
  cex = 0.5,
  col = "aquamarine4",
  xlab = "Age",
  ylab = "Percentile",
  ...
)
}
\arguments{
\item{normtable}{a \code{NormTable} object (created by \code{normtable_create()}
with \code{new_data = FALSE}).}

\item{lty}{line type(s) for curves.}

\item{lwd}{line width(s) for curves.}

\item{pch}{symbol for sample points.}

\item{cex}{point size (default: \code{0.5}).}

\item{col}{point colour (default: \code{"aquamarine4"}).}

\item{xlab}{x-axis label (default: \code{"Age"}).}

\item{ylab}{y-axis label (default: \code{"Percentile"}).}

\item{...}{additional graphical parameters passed to
\code{\link[graphics:plot.default]{graphics::plot()}}, \code{\link[graphics:lines]{graphics::lines()}}, or \code{\link[graphics:points]{graphics::points()}}.}
}
\value{
graphical output and the \code{ggplot} object used to create it.
}
\description{
\code{plot_normtable()} plots norm curves as a function of the predictor,
along with the sample data, based on a \code{NormTable} object.
}
\examples{
\donttest{
data("ids_data")

mydata_BB_y14 <- shape_data(
  data       = ids_data,
  age_name   = "age",
  score_name = "y14",
  family     = "BB"
)

mod_BB_y14 <- fb_select(
  data       = mydata_BB_y14,
  age_name   = "age",
  score_name = "shaped_score",
  family     = "BB",
  selcrit    = "BIC"
)

norm_mod_BB_y14 <- normtable_create(
  model      = mod_BB_y14,
  data       = mydata_BB_y14,
  age_name   = "age",
  score_name = "shaped_score"
)

# default plot
plot_normtable(norm_mod_BB_y14)
}

}
\seealso{
\code{\link[=normtable_create]{normtable_create()}}
}
