test_that("Ireland_symmetry", {
  n <- vision_data
  r <- nrow(n)
  result <- Ireland_symmetry(n)
  expected_x_star <- matrix(c(1521.96, 249.81, 120.60, 48.81,
                              249.81, 1513.95, 395.97, 80.08,
                              120.60, 395.97, 1774.29, 191.81,
                              48.81, 80.08, 191.81, 492.64), nrow=4, byrow=TRUE)

  expected_N <- 7477
  expect_equal(expected_N, sum(expected_x_star))

  expected_row_margin <- c(1941.18, 2239.81, 2482.67, 813.34)
  row_margin <- rowSums(expected_x_star)
  for (i in 1:r) {
    expect_true(abs(expected_row_margin[r] - row_margin[r]) <= 0.005,
                info=paste(r, expected_row_margin[r], row_margin[r]))
  }

  expected_col_margin <- c(1941.18, 2239.81, 2482.67, 813.34)
  col_margin <- colSums(expected_x_star)
  for (i in 1:r) {
    expect_true(abs(expected_col_margin[r] - col_margin[r]) <= 0.005,
                info=paste(r, expected_col_margin[r], col_margin[r]))
  }

  mdis <- Ireland_mdis(n, expected_x_star)

  x_star <- result$x_star
  for (i in 1:r) {
    for (j in 1:r) {
      expect_true(abs(expected_x_star[i, j] - x_star[i,j]) < 0.01,
                  info=paste(i, j, expected_x_star[i, j], x_star[i, j]))
    }
  }

  expected_mdis <- 19.295
  actual_mdis <- result$mdis
  expect_true(abs(expected_mdis - actual_mdis) <= 0.05,
              info=paste("mdis", expected_mdis, actual_mdis))
}
)


test_that("Ireland_marginal_homogeneity", {
  n <- vision_data
  r <- nrow(n)
  expected_x_star <- matrix(c(1521.22, 252.31, 111.28, 56.34,
                              247.10, 1513.21, 409.06, 70.25,
                              130.58, 382.92, 1773.42, 195.16,
                              42.24, 91.19, 188.33, 492.39), nrow=4, byrow=TRUE)

  expected_N <- 7477
  expect_equal(expected_N, sum(expected_x_star))

  expected_row_margin <- c(1941.15, 2239.62, 2482.08, 814.15)
  row_margin <- rowSums(expected_x_star)
  for (i in 1:r) {
    expect_true(abs(expected_row_margin[r] - row_margin[r]) <= 0.005,
                info=paste(r, expected_row_margin[r], row_margin[r]))
  }

  expected_col_margin <- c(1941.14, 2239.63, 2482.09, 814.14)
  col_margin <- colSums(expected_x_star)
  for (i in 1:r) {
    expect_true(abs(expected_col_margin[r] - col_margin[r]) <= 0.005,
                info=paste(r, expected_col_margin[r], col_margin[r]))
  }

  mdis <- Ireland_mdis(n, expected_x_star)

  result <- Ireland_marginal_homogeneity(n)
  x_star <- result$x_star
  for (i in 1:r) {
    for (j in 1:r) {
      expect_true(abs(expected_x_star[i, j] - x_star[i,j]) < 0.5,
                  info=paste(i, j, expected_x_star[i, j], x_star[i, j]))
    }
  }

  expected_mdis <- 11.998
  actual_mdis <- result$mdis
  expect_true(abs(expected_mdis - actual_mdis) <= 0.5,
              info=paste("mdis", expected_mdis, actual_mdis))
}
)


test_that("Ireland_quasi_symmetry", {
  n <- vision_data
  result <- Ireland_quasi_symmetry(n)
  expected_mdis <- 7.297
  actual_mdis <- result$mdis
  expect_true(abs(expected_mdis - actual_mdis) <= 0.5,
              info=paste("quasi-symmetry", expected_mdis, actual_mdis))
}
)


test_that("Ireland_normalize_for_truncation", {
  n <- vision_data
  r <- nrow(n)

  expected_n <- matrix(c(0, 266, 124, 66,
                         234, 0, 432, 78,
                         117, 362, 0, 205,
                         36, 82, 179, 0), ncol=4, byrow=TRUE)
  expected_N <- 2181
  expect_equal(expected_N, sum(expected_n))

  expected_row <- c(456, 744, 684, 297)
  actual_row <- rowSums(expected_n)
  expect_equal(expected_row, actual_row)

  expected_col <- c(387, 710, 735, 349)
  actual_col <- colSums(expected_n)
  expect_equal(expected_col, actual_col)

  expected_p <- expected_n / sum(expected_n)
  actual_n <- Ireland_normalize_for_truncation(n)
  actual_p <- actual_n / sum(actual_n)
  for (i in 1:r) {
    for (j in 1:r) {
      expect_true(abs(expected_p[i, j] - actual_p[i, j]) <= 0.0005,
                  info=paste(i, j, expected_p[i, j], actual_p[i, j]))
    }
  }
}
)


test_that("Ireland_symmetry_truncated", {
  n <- vision_data
  r <- nrow(n)
  expected_x_star <- matrix(c(0.0, 250.597, 120.985, 48.961,
                              250.597, 0.0, 397.214, 80.331,
                              120.985, 397.214, 0.0, 192.412,
                              48.961, 80.331, 192.412, 0.0),
                            nrow=4,byrow=TRUE)

  expected_N = 2181
  N <- sum(expected_x_star)
  expect_equal(expected_N, N, info=paste(expected_N, N))

  expected_row <- c(420.543, 728.142, 710.611, 321.704)
  actual_row <- rowSums(expected_x_star)
  for (i in 1:r) {
    expect_true(abs(expected_row[i] - actual_row[i]) <= 0.0005,
                info=paste("row", i, expected_row[i], actual_row[i]))
  }

  expected_col <- c(420.543, 728.142, 710.611, 321.704)
  actual_col <- colSums(expected_x_star)
  for (i in 1:r) {
    expect_true(abs(expected_col[i] - actual_col[i]) <= 0.0005,
                info=paste("col", i, expected_col[i], actual_col[i]))
  }

  result <- Ireland_symmetry(n, TRUE)

  actual_x_star <- result$x_star
  for (i in 1:r) {
    for (j in 1:r) {
      expect_true(abs(expected_x_star[i, j] - actual_x_star[i, j]) <= 0.0006,
                  info=paste(i, j, expected_x_star[i, j], actual_x_star[i, j]))
    }
  }

  expected_mdis <- 19.371
  actual_mdis <- result$mdis
  expect_true(abs(expected_mdis - actual_mdis) <= 0.5,
              info=paste(expected_mdis, actual_mdis))
}
)


test_that("Ireland_marginal_homogeneity_truncated", {
  n <- vision_data
  r <- nrow(n)
  expected_x_star <- matrix(c(0.0, 252.795, 111.496, 56.450,
                              247.583, 0.0, 409.855, 70.393,
                              130.839, 383.666, 0.0, 195.539,
                              42.323, 91.364, 188.697, 0.0), nrow=4, byrow=TRUE)

  expected_N <- 2181
  expect_equal(expected_N, sum(expected_x_star))

  expected_row_margin <- c(420.741, 727.831, 710.044, 322.384)
  row_margin <- rowSums(expected_x_star)
  for (i in 1:r) {
    expect_true(abs(expected_row_margin[r] - row_margin[r]) <= 0.005,
                info=paste(r, expected_row_margin[r], row_margin[r]))
  }

  expected_col_margin <- c(420.745, 727.825, 710.048, 322.382)
  col_margin <- colSums(expected_x_star)
  for (i in 1:r) {
    expect_true(abs(expected_col_margin[r] - col_margin[r]) <= 0.005,
                info=paste(r, expected_col_margin[r], col_margin[r]))
  }

  mdis <- Ireland_mdis(n, expected_x_star, TRUE)

  result <- Ireland_marginal_homogeneity(n, TRUE)
  x_star <- result$x_star
  for (i in 1:r) {
    for (j in 1:r) {
      if (i == j) {
        next
      }
      expect_true(abs(expected_x_star[i, j] - x_star[i,j]) < 0.5,
                  info=paste(i, j, expected_x_star[i, j], x_star[i, j]))
    }
  }

  expected_mdis <- 12.010
  actual_mdis <- result$mdis
  expect_true(abs(expected_mdis - actual_mdis) <= 0.5,
              info=paste("mdis", expected_mdis, actual_mdis))
}
)


test_that("Ireland_quasi_symmetry_truncated", {
  n <- vision_data
  r <- nrow(n)
  result <- Ireland_quasi_symmetry(n, TRUE)
  expected_mdis <- 7.361
  actual_mdis <- result$mdis
  expect_true(abs(expected_mdis - actual_mdis) <= 0.5,
              info=paste("quasi-symmetry", expected_mdis, actual_mdis))
}
)


test_that("Ireland_quasi_symmetry_model", {
  n <- vision_data
  r <- nrow(n)
  restrained_vision_data <- matrix(c(1520, 250, 120.5, 51,
                                     250, 1512, 397, 80,
                                     120.5, 397, 1772, 192,
                                     51, 80, 192, 492), nrow=4, byrow = TRUE)

  expected_N <- 7477
  expect_equal(expected_N, sum(restrained_vision_data))

  expected_rows <- c(1941.5, 2239, 2481.5, 815)
  actual_rows <- rowSums(restrained_vision_data)
  expect_equal(expected_rows, actual_rows)

  expected_cols <- c(1941.5, 2239, 2481.5, 815)
  actual_cols <- colSums(restrained_vision_data)
  expect_equal(expected_cols, actual_cols)

  expected_x_star <- matrix(c(1520.000, 263.380, 133.584, 59.036,
                              236.620, 1512.000, 418.986, 88.394,
                              107.416, 375.014, 1772.000, 201.570,
                              42.964, 71.606, 182.430, 492.000), nrow = 4, byrow=TRUE)

  expected_N <- 7477
  expect_equal(expected_N, sum(expected_x_star))

  expected_rows <- c(1976.000, 2256.000, 2456.000, 789.000)
  actual_rows <- rowSums(expected_x_star)
  expect_equal(expected_rows, actual_rows)

  expected_cols <- c(1907.000, 2222.000, 2507.000, 841.000)
  actual_cols <- colSums(expected_x_star)
  expect_equal(expected_cols, actual_cols)

  truncated <- TRUE
  result <- Ireland_quasi_symmetry_model(n, truncated)

  for (i in 1:r) {
    for (j in 1:r) {
      if (truncated && i == j) {
        next
      }
      expect_true(abs(expected_x_star[i, j] - result$x_star[i, j]) < 0.0006,
                  info=paste(i, j, expected_x_star[i, j], result$x_star[i,j]))
    }
  }

  expected_mdis <- 7.271
  expect_true(abs(expected_mdis - result$mdis) <= 0.05,
              info=paste("expected mdis", expected_mdis, result$mdis))
}
)
