% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_min_targets.R
\name{spec_min_targets}
\alias{spec_min_targets}
\title{Specify targets based on minima}
\usage{
spec_min_targets(x, ...)
}
\arguments{
\item{x}{An object specifying a target setting method.}

\item{...}{Additional objects specifying target setting methods.}
}
\value{
An object (\code{\linkS4class{TargetMethod}}) for specifying targets.
}
\description{
Specify targets that are calculated based on the minimum of one or more
target setting methods.
}
\section{Data calculations}{

This function involves calculating targets based on the spatial extent
of the features in \code{x}.
Although it can be readily applied to \code{\link[=problem]{problem()}} objects that
have the feature data provided as a \code{\link[terra:rast]{terra::rast()}} object,
you will need to specify the spatial units for the features
when initializing the \code{\link[=problem]{problem()}} objects if the feature data
are provided in a different format. In particular, if the feature
data are provided as a \code{data.frame} or \code{character} vector,
then you will need to specify an argument to \code{feature_units} when
using the \code{\link[=problem]{problem()}} function.
See the Examples section of the documentation for \code{\link[=add_auto_targets]{add_auto_targets()}}
for a demonstration of specifying the spatial units for features.
}

\examples{
\dontrun{
# set seed for reproducibility
set.seed(500)

# load data
sim_complex_pu_raster <- get_sim_complex_pu_raster()
sim_complex_features <- get_sim_complex_features()

# create base problem
p0 <-
  problem(sim_complex_pu_raster, sim_complex_features) \%>\%
  add_min_set_objective() \%>\%
  add_binary_decisions() \%>\%
  add_default_solver(verbose = FALSE)

# create problem with 20\% targets
p1 <-
  p0 \%>\%
  add_auto_targets(method = spec_relative_targets(0.2))

# create problem with Jung et al. (2021) targets
p2 <-
  p0 \%>\%
  add_auto_targets(method = spec_jung_targets())

# create problem with Polak et al. (2015) targets
p3 <-
  p0 \%>\%
  add_auto_targets(method = spec_polak_targets())

# create problem with targets based on the minimum of 20\% targets,
# Jung et al. (2021) targets, and Polak et al. (2015) targets
# for each feature (separately)
p4 <-
  p0 \%>\%
  add_auto_targets(
    method = spec_min_targets(
      spec_relative_targets(0.2),
      spec_jung_targets(),
      spec_polak_targets()
    )
  )

# solve problems
s <- c(solve(p1), solve(p2), solve(p3), solve(p4))
names(s) <- c("20\% targets", "Jung targets", "Polak targets", "min targets")

# plot solutions
plot(s, axes = FALSE)
}
}
\seealso{
Other target setting methods:
\code{\link{spec_absolute_targets}()},
\code{\link{spec_area_targets}()},
\code{\link{spec_duran_targets}()},
\code{\link{spec_interp_absolute_targets}()},
\code{\link{spec_interp_area_targets}()},
\code{\link{spec_jung_targets}()},
\code{\link{spec_max_targets}()},
\code{\link{spec_polak_targets}()},
\code{\link{spec_pop_size_targets}()},
\code{\link{spec_relative_targets}()},
\code{\link{spec_rl_ecosystem_targets}()},
\code{\link{spec_rl_species_targets}()},
\code{\link{spec_rodrigues_targets}()},
\code{\link{spec_rule_targets}()},
\code{\link{spec_ward_targets}()},
\code{\link{spec_watson_targets}()},
\code{\link{spec_wilson_targets}()}
}
\concept{methods}
