% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_path}
\alias{search_path}
\title{Find a model in the apsimx file using specified path}
\usage{
search_path(l, path, case_insensitive = TRUE)
}
\arguments{
\item{l}{the list of apsimx file}

\item{path}{The specified path (See details)}

\item{case_insensitive}{Whether case sensitive}
}
\value{
The list for the specified path.
}
\description{
Find a model in the apsimx file using specified path
}
\section{Absolute Paths}{

Absolute paths have a leading ‘.’ e.g.
\itemize{
  \item .Simulations.Test.Clock - absolute path - refers to the clock model
in the 'Test' simulation.
}
}

\section{Scoped Paths}{

Scoped paths have a leading model type in square brackets. A model
of the specified name, in scope, is located before applying the rest of the path.
\itemize{
   \item [Soil].Water - scoped path - refers to the Water model that is a child of a model
that has the name 'Soil' that is in scope
}
}

\examples{
wheat <- read_apsimx(system.file("extdata/Wheat.json", package = "rapsimng"))
# Return empty list if not found
search_path(wheat, "[Simulations1]")
# Search root path
a <- search_path(wheat, '.Simulations')
a$path
a$node$Name
# Level one
a <- search_path(wheat, '.Simulations.Wheat1')
a$path
a$node$Name
# Level two
a <- search_path(wheat, '.Simulations.Wheat')
a$path
a$node$Name
# Level three
a <- search_path(wheat, '.Simulations.Wheat.BranchingRate')
a$path
a$node$Name
a <- search_path(wheat, '.Simulations.Wheat.Structure')
a$path
a$node$Name
# Level four
a <- search_path(wheat, '.Simulations.Wheat.Structure.BranchingRate')
a$path
a$node$Name
a <- search_path(wheat, '.Simulations.Wheat.Structure.BranchingRate1')
a$path
a$node$Name
# scoped
# Root path
a <- search_path(wheat, '[Simulations1]')
a <- search_path(wheat, '[Simulations]')
a$path
a$node$Name
# Level two
a <- search_path(wheat, '[Simulations].Wheat1')
a <- search_path(wheat, '[Simulations1].Wheat')
a$path
a$node$Name
a <- search_path(wheat, '[Whea]')
a <- search_path(wheat, '[Wheat]')
a$path
a$node$Name
# Level three
a <- search_path(wheat, '[Wheat].BranchingRate')
a <- search_path(wheat, '[Wheat].Structure')
a$path
a$node$Name
a <- search_path(wheat, '[Structure]')
a$path
a$node$Name
# Level four
a <- search_path(wheat, '[Structure].BranchingRate')
a$path
a$node$Name
a <- search_path(wheat, '[Structure].BranchingRate1')
a <- search_path(wheat, '[Structure1].BranchingRate')
}
