% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_phyloseq.R
\name{build_phyloseq}
\alias{build_phyloseq}
\title{Build phyloseq objects for all taxonomy ranks}
\usage{
build_phyloseq(
  X,
  sample_data,
  taxa_table = NULL,
  phylo_tree = NULL,
  taxa_in_rows,
  verbose = TRUE
)
}
\arguments{
\item{X}{A numeric matrix of NGS features (e.g., ASVs), with samples in rows
and features in columns (recommended) or vice versa.}

\item{sample_data}{A \code{data.frame} containing sample data.
Row names must match sample identifiers in \code{X}.}

\item{taxa_table}{(Optional) A taxonomy table with row names corresponding to
feature names in \code{X}, and taxonomic ranks as columns.}

\item{phylo_tree}{(Optional) A phylogenetic tree.}

\item{taxa_in_rows}{Logical. If \code{TRUE}, \code{X} is assumed to have taxa as rows
and samples as columns.}

\item{verbose}{Logical. If \code{TRUE}, diagnostic messages will be printed.}
}
\value{
A named \code{list} of \code{phyloseq} objects and related output:
\describe{
\item{asv}{Phyloseq object with the raw feature counts (usually ASVs).}
\item{<tax_rank>}{Phyloseq objects of higher taxonomy ranks from \code{taxa_table}.}
}
}
\description{
Constructs a list of phyloseq objects from a feature matrix (\code{X}), sample data,
taxonomy and (optionally) phylogenetic tree data.
}
\details{
Phyloseq objects for higher taxonomic ranks are also generated when \code{taxa_table} is provided.
Higher rank taxa with labels matching "unclass" or "unknown" are excluded
after aggregation.

If very long strings are detected as feature IDs in \code{X} matrix or \code{taxa_table},
(for example when actual DNA sequence is used as ID), it will issue a warning,
as this could significantly slow down computation and increase memory usage.
}
\examples{
if (requireNamespace("phyloseq", quietly = TRUE)) {
mock_X <- matrix(c(10, 0, 5, 3, 1, 7),
                 nrow = 2, byrow = TRUE,
                 dimnames = list(c("sample1", "sample2"),
                                 c("ASV1", "ASV2", "ASV3"))
                 )

mock_sample_data <- data.frame(sample_id = c("sample1", "sample2"),
                               group = c("A", "B"),
                               row.names = c("sample1", "sample2")
                               )

mock_taxa_table <- data.frame(Domain = c("Bacteria", "Bacteria", "Bacteria"),
                              Genus = c("GenusA", "GenusB", "Unknown"),
                              row.names = c("ASV1", "ASV2", "ASV3")
                              )

phyloseq_ready <- build_phyloseq(X = mock_X,
                                 sample_data = mock_sample_data,
                                 taxa_table = mock_taxa_table,
                                 taxa_in_rows = FALSE,
                                 verbose = FALSE)
}

}
\seealso{
\code{\link[phyloseq:phyloseq]{phyloseq::phyloseq()}} for further details on phyloseq objects.
}
