% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{scenario_list}
\alias{scenario_list}
\title{Create list of parameter scenarios}
\usage{
scenario_list(..., each = 1)
}
\arguments{
\item{...}{Named arguments defining parameters. Arguments may be regular
vectors or \code{grouped_params} objects created with \code{\link{grouped}}.}

\item{each}{Integer representing the number of replications for each scenario
or set of parameters. Defaults to 1.}
}
\value{
A list of scenarios, where each element is a named vector of parameter
values with an added element \code{scenario} giving the scenario index.
}
\description{
Generates a list of scenarios by expanding combinations of
regular parameters and preserving grouped parameters that must vary together.
}
\examples{
# Regular parameters
s1 <- scenario_list(a = 1:2, b = c("x", "y"))

# Grouped parameters
g <- grouped(x = 1:2, y = c(10, 20))
s2 <- scenario_list(a = c("low", "high"), g, each = 3)

# Inspect first few scenarios
head(s1)
head(s2)
}
\seealso{
\code{\link{grouped}} for creating grouped parameter objects.
}
\concept{utility}
