% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_rw}
\alias{gen_rw}
\title{Generate a Random Walk without Drift}
\usage{
gen_rw(N, sigma2 = 1)
}
\arguments{
\item{N}{An \code{integer} for signal length.}

\item{sigma2}{A \code{double} that contains process variance.}
}
\value{
grw A \code{vec} containing the random walk without drift.
}
\description{
Generates a random walk without drift.
}
\section{Process Definition}{
 
Random Walk (RW) with parameter \eqn{\gamma^2 \in {\rm I\!R}^{+}}{gamma in R^{+}}. This process is defined as:
\deqn{{X_t} = \sum\limits_{t = 1}^T {\gamma {Z_t}} }{X[t] = sum(gamma*Z[t])}
and is often called \emph{Rate Random Walk} in the engineering literature.
}

\section{Generation Algorithm}{

To generate we first obtain the standard deviation from the variance by taking a square root. Then, we 
sample \eqn{N} times from a \eqn{N(0,\sigma^2)}{N(0,sigma^2)} distribution. Lastly, we take the
cumulative sum over the vector.
}

\keyword{internal}
