% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.group_tna_cliques}
\alias{plot.group_tna_cliques}
\title{Plot Found Cliques}
\usage{
\method{plot}{group_tna_cliques}(x, title, ...)
}
\arguments{
\item{x}{A \code{group_tna_cliques} object.}

\item{title}{A \code{character} vector of titles to use for each plot.}

\item{...}{Arguments passed to \code{\link[=plot.tna_cliques]{plot.tna_cliques()}}.}
}
\value{
A \code{list} (invisibly) with one element per cluster. Each element
contains a \code{qgraph} plot when only one clique is present per cluster,
otherwise the element is \code{NULL}.
}
\description{
Plot Found Cliques
}
\examples{
model <- group_model(engagement_mmm)
cliq <- cliques(model, size = 2)
plot(cliq, ask = FALSE)

}
\seealso{
Clique-related functions
\code{\link{cliques}()},
\code{\link{plot.tna_cliques}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.tna_cliques}()}
}
\concept{cliques}
