% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency_graph.R
\name{build_dependency_graph}
\alias{build_dependency_graph}
\title{Build a field dependency graph from calculated fields}
\usage{
build_dependency_graph(fields_df)
}
\arguments{
\item{fields_df}{A data frame with at least columns \code{name} and \code{formula}.}
}
\value{
An \code{igraph} directed graph where vertices are field names and edges
represent dependencies (input \if{html}{\out{&rarr;}}\if{latex}{->} output).
}
\description{
Creates a directed graph where edges point from input fields used in a
formula to the calculated output field. Tokens are extracted from bracketed
references like \verb{[Table].[Field]} or \verb{[Field]}.
}
\examples{

fields <- tibble::tibble(
name = c("X_plus_Y", "Z"),
formula = c("[X] + [Y]", "[X_plus_Y] * 2")
)
g <- build_dependency_graph(fields)


}
